/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.maven;

import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ResolutionErrorHandler;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.compiler.DependencyCoordinate;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;

@Named
class KotlinArtifactResolver {
    private final RepositorySystem repoSystem;
    private final ArtifactHandlerManager artifactHandlerManager;
    private final MavenSession session;
    private final MavenProject project;
    private final ResolutionErrorHandler resolutionErrorHandler;

    @Inject
    KotlinArtifactResolver(RepositorySystem repoSystem, ArtifactHandlerManager artifactHandlerManager, MavenSession session, MavenProject project, ResolutionErrorHandler resolutionErrorHandler) {
        this.repoSystem = repoSystem;
        this.artifactHandlerManager = artifactHandlerManager;
        this.session = session;
        this.project = project;
        this.resolutionErrorHandler = resolutionErrorHandler;
    }

    Set<Artifact> resolveArtifact(String group, String artifactId, String version) throws ArtifactResolutionException {
        DependencyCoordinate dependency = new DependencyCoordinate();
        dependency.setGroupId(group);
        dependency.setArtifactId(artifactId);
        dependency.setVersion(version);
        ArtifactHandler handler = this.artifactHandlerManager.getArtifactHandler(dependency.getType());
        DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), "runtime", dependency.getType(), dependency.getClassifier(), handler);
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact((Artifact)artifact).setResolveRoot(true).setResolveTransitively(true).setLocalRepository(this.session.getLocalRepository()).setRemoteRepositories(this.project.getRemoteArtifactRepositories());
        ArtifactResolutionResult resolutionResult = this.repoSystem.resolve(request);
        this.resolutionErrorHandler.throwErrors(request, resolutionResult);
        return resolutionResult.getArtifacts();
    }
}

