/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.buildinfo.deployment;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.execution.AbstractExecutionListener;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.apache.maven.repository.legacy.metadata.ArtifactMetadata;
import org.jfrog.build.api.Artifact;
import org.jfrog.build.api.BaseBuildFileBean;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.Dependency;
import org.jfrog.build.api.builder.ArtifactBuilder;
import org.jfrog.build.api.builder.BuildInfoMavenBuilder;
import org.jfrog.build.api.builder.DependencyBuilder;
import org.jfrog.build.api.builder.ModuleBuilder;
import org.jfrog.build.extractor.BuildInfoExtractor;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.IncludeExcludePatterns;
import org.jfrog.build.extractor.clientConfiguration.PatternMatcher;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.buildinfo.deployment.BuildDeployer;
import org.jfrog.buildinfo.deployment.BuildInfoModelPropertyResolver;
import org.jfrog.buildinfo.types.ModuleArtifacts;
import org.jfrog.buildinfo.utils.Utils;

public class BuildInfoRecorder
implements BuildInfoExtractor<ExecutionEvent>,
ExecutionListener {
    private final Map<String, DeployDetails> deployableArtifacts = Maps.newConcurrentMap();
    private final Set<org.apache.maven.artifact.Artifact> buildTimeDependencies = Collections.synchronizedSet(new HashSet());
    private final ModuleArtifacts currentModuleDependencies = new ModuleArtifacts();
    private final ModuleArtifacts currentModuleArtifacts = new ModuleArtifacts();
    private final ThreadLocal<ModuleBuilder> currentModule = new ThreadLocal();
    private final BuildInfoMavenBuilder buildInfoBuilder;
    private final ArtifactoryClientConfiguration conf;
    private final ExecutionListener wrappedListener;
    private final BuildDeployer buildDeployer;
    private final Log logger;

    public BuildInfoRecorder(MavenSession session, Log logger, ArtifactoryClientConfiguration conf) {
        this.wrappedListener = (ExecutionListener)ObjectUtils.defaultIfNull((Object)session.getRequest().getExecutionListener(), (Object)new AbstractExecutionListener());
        this.buildInfoBuilder = new BuildInfoModelPropertyResolver(logger, session, conf);
        this.buildDeployer = new BuildDeployer(logger);
        this.logger = logger;
        this.conf = conf;
    }

    public void projectSucceeded(ExecutionEvent event) {
        MavenProject project = event.getProject();
        ModuleBuilder moduleBuilder = new ModuleBuilder().id(BuildInfoExtractorUtils.getModuleIdString((String)project.getGroupId(), (String)project.getArtifactId(), (String)project.getVersion())).properties(project.getProperties());
        this.conf.getAllProperties().replaceAll((key, value) -> Utils.parseInput(value));
        this.addArtifacts(project);
        this.addDependencies(project);
        this.addArtifactsToCurrentModule(project, moduleBuilder);
        this.addDependenciesToCurrentModule(moduleBuilder);
        this.buildInfoBuilder.addModule(moduleBuilder.build());
        this.currentModule.remove();
        this.currentModuleArtifacts.remove();
        this.currentModuleDependencies.remove();
        this.buildTimeDependencies.clear();
        this.wrappedListener.projectSucceeded(event);
    }

    public void mojoSucceeded(ExecutionEvent event) {
        this.addDependencies(event.getProject());
        this.wrappedListener.mojoSucceeded(event);
    }

    public void mojoFailed(ExecutionEvent event) {
        this.addDependencies(event.getProject());
        this.wrappedListener.mojoFailed(event);
    }

    public void sessionEnded(ExecutionEvent event) {
        Build build = this.extract(event);
        if (build != null) {
            this.buildDeployer.deploy(build, this.conf, this.deployableArtifacts);
        }
        this.deployableArtifacts.clear();
        this.wrappedListener.sessionEnded(event);
    }

    public Build extract(ExecutionEvent event) {
        MavenSession session = event.getSession();
        if (session.getResult().hasExceptions()) {
            return null;
        }
        if (this.conf.isIncludeEnvVars().booleanValue()) {
            Properties envProperties = new Properties();
            envProperties.putAll((Map<?, ?>)this.conf.getAllProperties());
            envProperties = BuildInfoExtractorUtils.getEnvProperties((Properties)envProperties, (org.jfrog.build.api.util.Log)this.conf.getLog());
            envProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(arg_0, arg_1) -> ((BuildInfoMavenBuilder)this.buildInfoBuilder).addProperty(arg_0, arg_1)));
        }
        long time = new Date().getTime() - session.getRequest().getStartTime().getTime();
        return this.buildInfoBuilder.durationMillis(time).build();
    }

    public Set<org.apache.maven.artifact.Artifact> getCurrentModuleDependencies() {
        return (Set)this.currentModuleDependencies.get();
    }

    public BuildInfoMavenBuilder getBuildInfoBuilder() {
        return this.buildInfoBuilder;
    }

    public void artifactResolved(org.apache.maven.artifact.Artifact artifact) {
        if (artifact != null) {
            this.buildTimeDependencies.add(artifact);
        }
    }

    private void addArtifacts(MavenProject project) {
        this.currentModuleArtifacts.add(project.getArtifact());
        this.currentModuleArtifacts.addAll(project.getAttachedArtifacts());
    }

    private void addDependencies(MavenProject project) {
        HashSet dependencies = Sets.newHashSet();
        for (org.apache.maven.artifact.Artifact artifact : project.getArtifacts()) {
            String classifier = StringUtils.defaultString((String)artifact.getClassifier());
            String scope = (String)StringUtils.defaultIfBlank((CharSequence)artifact.getScope(), (CharSequence)"compile");
            DefaultArtifact art = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), scope, artifact.getType(), classifier, artifact.getArtifactHandler());
            art.setFile(artifact.getFile());
            dependencies.add(art);
        }
        dependencies.addAll(this.currentModuleDependencies.getOrCreate());
        if (this.conf.publisher.isRecordAllDependencies()) {
            dependencies.addAll(this.buildTimeDependencies);
        }
        this.currentModuleDependencies.set(dependencies);
    }

    private void addArtifactsToCurrentModule(MavenProject project, ModuleBuilder moduleBuilder) {
        Set<org.apache.maven.artifact.Artifact> artifacts = this.currentModuleArtifacts.getOrCreate();
        IncludeExcludePatterns patterns = new IncludeExcludePatterns(this.conf.publisher.getIncludePatterns(), this.conf.publisher.getExcludePatterns());
        boolean excludeArtifactsFromBuild = this.conf.publisher.isFilterExcludedArtifactsFromBuild();
        boolean pomFileAdded = false;
        org.apache.maven.artifact.Artifact nonPomArtifact = null;
        String pomFileName = null;
        for (org.apache.maven.artifact.Artifact moduleArtifact : artifacts) {
            String artifactId = moduleArtifact.getArtifactId();
            String artifactVersion = moduleArtifact.getVersion();
            String artifactClassifier = moduleArtifact.getClassifier();
            String artifactExtension = moduleArtifact.getArtifactHandler().getExtension();
            String type = BuildInfoExtractorUtils.getTypeString((String)moduleArtifact.getType(), (String)artifactClassifier, (String)artifactExtension);
            String artifactName = Utils.getArtifactName(artifactId, artifactVersion, artifactClassifier, artifactExtension);
            File artifactFile = moduleArtifact.getFile();
            if ("pom".equals(type)) {
                pomFileAdded = true;
                if (moduleArtifact.equals(project.getArtifact())) {
                    artifactFile = project.getFile();
                }
            } else {
                boolean pomExist = moduleArtifact.getMetadataList().stream().anyMatch(artifactMetadata -> artifactMetadata instanceof ProjectArtifactMetadata);
                if (pomExist) {
                    nonPomArtifact = moduleArtifact;
                    pomFileName = StringUtils.removeEnd((String)artifactName, (String)artifactExtension) + "pom";
                }
            }
            Artifact artifact = new ArtifactBuilder(artifactName).type(type).build();
            String groupId = moduleArtifact.getGroupId();
            String deploymentPath = Utils.getDeploymentPath(groupId, artifactId, artifactVersion, artifactClassifier, artifactExtension);
            if (!Utils.isFile(artifactFile)) continue;
            boolean pathConflicts = PatternMatcher.pathConflicts((String)deploymentPath, (IncludeExcludePatterns)patterns);
            this.addArtifactToBuildInfo(moduleBuilder, artifact, pathConflicts, excludeArtifactsFromBuild);
            this.addDeployableArtifact(moduleBuilder, artifact, artifactFile, pathConflicts, moduleArtifact.getGroupId(), artifactId, artifactVersion, artifactClassifier, artifactExtension);
        }
        if (!pomFileAdded && nonPomArtifact != null) {
            String deploymentPath = Utils.getDeploymentPath(nonPomArtifact.getGroupId(), nonPomArtifact.getArtifactId(), nonPomArtifact.getVersion(), nonPomArtifact.getClassifier(), "pom");
            this.addPomArtifact(moduleBuilder, nonPomArtifact, patterns, deploymentPath, pomFileName, excludeArtifactsFromBuild);
        }
    }

    private void addDependenciesToCurrentModule(ModuleBuilder moduleBuilder) {
        for (org.apache.maven.artifact.Artifact moduleDependency : this.currentModuleDependencies.getOrCreate()) {
            File depFile = moduleDependency.getFile();
            DependencyBuilder dependencyBuilder = new DependencyBuilder().id(BuildInfoExtractorUtils.getModuleIdString((String)moduleDependency.getGroupId(), (String)moduleDependency.getArtifactId(), (String)moduleDependency.getVersion())).type(BuildInfoExtractorUtils.getTypeString((String)moduleDependency.getType(), (String)moduleDependency.getClassifier(), (String)Utils.getFileExtension(depFile)));
            String scopes = moduleDependency.getScope();
            if (StringUtils.isNotBlank((CharSequence)scopes)) {
                dependencyBuilder.scopes((Set)Sets.newHashSet((Object[])new String[]{scopes}));
            }
            Dependency dependency = dependencyBuilder.build();
            Utils.setChecksums(depFile, (BaseBuildFileBean)dependency, this.logger);
            moduleBuilder.addDependency(dependency);
        }
    }

    private void addPomArtifact(ModuleBuilder moduleBuilder, org.apache.maven.artifact.Artifact nonPomArtifact, IncludeExcludePatterns patterns, String deploymentPath, String pomFileName, boolean excludeArtifactsFromBuild) {
        ArtifactMetadata artifactMetadata = nonPomArtifact.getMetadataList().stream().filter(artifact -> artifact instanceof ProjectArtifactMetadata).findFirst().orElse(null);
        if (artifactMetadata == null) {
            return;
        }
        File pomFile = ((ProjectArtifactMetadata)artifactMetadata).getFile();
        if (!Utils.isFile(pomFile)) {
            return;
        }
        ArtifactBuilder artifactBuilder = new ArtifactBuilder(pomFileName).type("pom");
        Artifact pomArtifact = artifactBuilder.build();
        boolean pathConflicts = PatternMatcher.pathConflicts((String)deploymentPath, (IncludeExcludePatterns)patterns);
        this.addArtifactToBuildInfo(moduleBuilder, pomArtifact, pathConflicts, excludeArtifactsFromBuild);
        this.addDeployableArtifact(moduleBuilder, pomArtifact, pomFile, pathConflicts, nonPomArtifact.getGroupId(), nonPomArtifact.getArtifactId(), nonPomArtifact.getVersion(), nonPomArtifact.getClassifier(), "pom");
    }

    private void addArtifactToBuildInfo(ModuleBuilder module, Artifact artifact, boolean pathConflicts, boolean isFilterExcludedArtifactsFromBuild) {
        if (isFilterExcludedArtifactsFromBuild && pathConflicts) {
            module.addExcludedArtifact(artifact);
            return;
        }
        module.addArtifact(artifact);
    }

    private void addDeployableArtifact(ModuleBuilder module, Artifact artifact, File artifactFile, boolean pathConflicts, String groupId, String artifactId, String version, String classifier, String fileExtension) {
        if (pathConflicts) {
            this.logger.info((CharSequence)("'" + artifact.getName() + "' will not be deployed due to the defined include-exclude patterns."));
            return;
        }
        String deploymentPath = Utils.getDeploymentPath(groupId, artifactId, version, classifier, fileExtension);
        String targetRepository = this.getTargetRepository(deploymentPath);
        DeployDetails deployable = new DeployDetails.Builder().artifactPath(deploymentPath).file(artifactFile).targetRepository(targetRepository).addProperties((Map)this.conf.publisher.getMatrixParams()).packageType(DeployDetails.PackageType.MAVEN).build();
        String myArtifactId = BuildInfoExtractorUtils.getArtifactId((String)module.build().getId(), (String)artifact.getName());
        this.deployableArtifacts.put(myArtifactId, deployable);
    }

    public String getTargetRepository(String deployPath) {
        String snapshotsRepository = this.conf.publisher.getSnapshotRepoKey();
        if (snapshotsRepository != null && deployPath.contains("-SNAPSHOT")) {
            return snapshotsRepository;
        }
        return this.conf.publisher.getRepoKey();
    }

    public void projectDiscoveryStarted(ExecutionEvent event) {
        this.wrappedListener.projectDiscoveryStarted(event);
    }

    public void sessionStarted(ExecutionEvent event) {
        this.wrappedListener.sessionStarted(event);
    }

    public void projectSkipped(ExecutionEvent event) {
        this.wrappedListener.projectSkipped(event);
    }

    public void projectStarted(ExecutionEvent event) {
        this.wrappedListener.projectStarted(event);
    }

    public void projectFailed(ExecutionEvent event) {
        this.wrappedListener.projectFailed(event);
    }

    public void forkStarted(ExecutionEvent event) {
        this.wrappedListener.forkStarted(event);
    }

    public void forkSucceeded(ExecutionEvent event) {
        this.wrappedListener.forkSucceeded(event);
    }

    public void forkFailed(ExecutionEvent event) {
        this.wrappedListener.forkFailed(event);
    }

    public void mojoSkipped(ExecutionEvent event) {
        this.wrappedListener.mojoSkipped(event);
    }

    public void mojoStarted(ExecutionEvent event) {
        this.wrappedListener.mojoStarted(event);
    }

    public void forkedProjectStarted(ExecutionEvent event) {
        this.wrappedListener.forkedProjectStarted(event);
    }

    public void forkedProjectSucceeded(ExecutionEvent event) {
        this.wrappedListener.forkedProjectSucceeded(event);
    }

    public void forkedProjectFailed(ExecutionEvent event) {
        this.wrappedListener.forkedProjectFailed(event);
    }
}

