/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.spring;

import java.util.Optional;
import org.jmolecules.ddd.types.AggregateRoot;
import org.jmolecules.ddd.types.Association;
import org.jmolecules.ddd.types.Identifier;
import org.jmolecules.spring.AggregateLookup;
import org.springframework.util.Assert;

public interface AssociationResolver<T extends AggregateRoot<T, ID>, ID extends Identifier>
extends AggregateLookup<T, ID> {
    default public Optional<T> resolve(Association<T, ID> association) {
        Assert.notNull(association, (String)"Association must not be null!");
        return this.findById(association.getId());
    }

    default public T resolveRequired(Association<T, ID> association) {
        Assert.notNull(association, (String)"Association must not be null!");
        return (T)((AggregateRoot)this.resolve(association).orElseThrow(() -> new IllegalArgumentException(String.format("Could not resolve association %s!", association))));
    }
}

