/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.spring;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jmolecules.ddd.types.Identifier;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ReflectionUtils;

public class PrimitivesToIdentifierConverter
implements ConditionalGenericConverter {
    private static final Map<Class<?>, Optional<Method>> CACHE = new ConcurrentReferenceHashMap();
    private static final Set<Class<?>> DEFAULT_PRIMITIVES = new HashSet<Class>(Arrays.asList(String.class, UUID.class));
    private static final Set<String> DEFAULT_FACTORY_METHOD_NAMES = new HashSet<String>(Arrays.asList("of"));
    private final Supplier<? extends ConversionService> conversionService;
    private Set<Class<?>> primitives = new HashSet(DEFAULT_PRIMITIVES);
    private Set<String> factoryMethodNames = new HashSet<String>(DEFAULT_FACTORY_METHOD_NAMES);

    public PrimitivesToIdentifierConverter(Supplier<? extends ConversionService> conversionService) {
        this.conversionService = conversionService;
    }

    @NonNull
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return this.primitives.stream().map(it -> new GenericConverter.ConvertiblePair(it, Identifier.class)).collect(Collectors.toSet());
    }

    public boolean matches(TypeDescriptor source, TypeDescriptor target) {
        return CACHE.computeIfAbsent(target.getType(), this::detectCreatorMethod).filter(it -> this.isAssignableOrConverable(it.getParameterTypes()[0], source.getType())).isPresent();
    }

    @Nullable
    public Object convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor target) {
        if (source == null) {
            return null;
        }
        Class type = target.getType();
        Class<?> valueType = source.getClass();
        Method method = CACHE.computeIfAbsent(type, this::detectCreatorMethod).filter(it -> this.isAssignableOrConverable(it.getParameterTypes()[0], valueType)).orElseThrow(() -> new IllegalStateException(String.format("No factory method taking a parameter of type %s on %s!", valueType.getSimpleName(), type.getSimpleName())));
        Class<?> parameterType = method.getParameterTypes()[0];
        if (!parameterType.isInstance(source)) {
            source = this.conversionService.get().convert(source, TypeDescriptor.forObject((Object)source), TypeDescriptor.valueOf(parameterType));
        }
        return ReflectionUtils.invokeMethod((Method)method, null, (Object[])new Object[]{source});
    }

    private Optional<Method> detectCreatorMethod(Class<?> type) {
        return this.factoryMethodNames.stream().flatMap(name -> this.primitives.stream().map(primitive -> new Signature((String)name, (Class<?>)primitive))).map(it -> ReflectionUtils.findMethod((Class)type, (String)((Signature)it).name, (Class[])new Class[]{((Signature)it).argumentType})).filter(it -> it != null).peek(ReflectionUtils::makeAccessible).findFirst();
    }

    private boolean isAssignableOrConverable(Class<?> source, Class<?> target) {
        return source.isAssignableFrom(target) || this.conversionService.get().canConvert(source, target);
    }

    private static final class Signature {
        private final String name;
        private final Class<?> argumentType;

        @Generated
        public Signature(String name, Class<?> argumentType) {
            this.name = name;
            this.argumentType = argumentType;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public Class<?> getArgumentType() {
            return this.argumentType;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Signature)) {
                return false;
            }
            Signature other = (Signature)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Class<?> this$argumentType = this.getArgumentType();
            Class<?> other$argumentType = other.getArgumentType();
            return !(this$argumentType == null ? other$argumentType != null : !this$argumentType.equals(other$argumentType));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Class<?> $argumentType = this.getArgumentType();
            result = result * 59 + ($argumentType == null ? 43 : $argumentType.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PrimitivesToIdentifierConverter.Signature(name=" + this.getName() + ", argumentType=" + this.getArgumentType() + ")";
        }
    }
}

