/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.jsr160;

import java.util.HashMap;
import java.util.Map;
import org.jolokia.json.JSONObject;

public class ProxyTargetConfig {
    private final String url;
    private Map<String, String> env;

    public ProxyTargetConfig(Map<String, String> pMap) {
        if (pMap == null || pMap.get("url") == null) {
            throw new IllegalArgumentException("No service url given for JSR-160 target");
        }
        this.url = pMap.get("url");
        String user = pMap.get("user");
        if (user != null) {
            this.env = new HashMap<String, String>();
            this.env.put("user", user);
            String pwd = pMap.get("password");
            if (pwd != null) {
                this.env.put("password", pwd);
            }
        }
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public JSONObject toJSON() {
        JSONObject ret = new JSONObject();
        ret.put("url", this.url);
        if (this.env != null) {
            ret.put("env", this.env);
        }
        return ret;
    }

    public String toString() {
        return "TargetConfig[" + this.url + ", " + String.valueOf(this.env) + "]";
    }
}

