/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.security.asn1;

import org.jolokia.jvmagent.security.asn1.DERBitString;
import org.jolokia.jvmagent.security.asn1.DERBoolean;
import org.jolokia.jvmagent.security.asn1.DERInteger;
import org.jolokia.jvmagent.security.asn1.DERNull;
import org.jolokia.jvmagent.security.asn1.DERObject;
import org.jolokia.jvmagent.security.asn1.DERObjectIdentifier;
import org.jolokia.jvmagent.security.asn1.DERSequence;

public class DERUtils {
    private DERUtils() {
    }

    public static byte[] encodeLength(int size) {
        int start;
        if (size < 0) {
            throw new IllegalArgumentException("Can't encode negative length");
        }
        int s = size;
        byte[] lengthEncoded = new byte[4];
        for (int i = 3; i >= 0; --i) {
            lengthEncoded[i] = (byte)(s & 0xFF);
            s >>>= 8;
        }
        for (start = 0; start < 4 && lengthEncoded[start] == 0; ++start) {
        }
        if (size <= 127) {
            return new byte[]{lengthEncoded[3]};
        }
        byte[] result = new byte[4 - start + 1];
        result[0] = (byte)(4 - start | 0x80);
        System.arraycopy(lengthEncoded, start, result, 1, 4 - start);
        return result;
    }

    public static int[] decodeLength(byte[] encoded) {
        return DERUtils.decodeLength(encoded, 0);
    }

    public static int[] decodeLength(byte[] encoded, int offset) {
        if ((encoded[offset] & 0x80) == 0) {
            return new int[]{encoded[offset], 1};
        }
        int ll = encoded[offset] & 0x7F;
        if (ll > 4) {
            throw new IllegalArgumentException("Can't decode DER value with length over 2^32");
        }
        int[] result = new int[]{0, ll + 1};
        while (ll > 0) {
            result[0] = result[0] | (encoded[++offset] & 0xFF) << --ll * 8;
        }
        return result;
    }

    public static DERObject parse(byte[] encoded) {
        return DERUtils.parse(encoded, 0);
    }

    public static DERObject parse(byte[] encoded, int offset) {
        if (encoded == null || encoded.length < 2) {
            throw new IllegalArgumentException("Can't DER-decode null/empty/insufficient byte array");
        }
        byte id = encoded[offset];
        int cls = id & 0xC0;
        boolean primitive = (id & 0x20) == 0;
        int tag = id & 0x1F;
        if (tag == 31) {
            throw new IllegalArgumentException("Can't decode tags with number higher than 30");
        }
        int[] lo = DERUtils.decodeLength(encoded, offset + 1);
        switch (tag) {
            case 1: {
                return DERBoolean.parse(encoded, offset + 1);
            }
            case 2: {
                return DERInteger.parse(encoded, lo[0], offset + 1 + lo[1]);
            }
            case 3: {
                return DERBitString.parse(encoded, lo[0], offset + 1 + lo[1]);
            }
            case 4: {
                break;
            }
            case 5: {
                return new DERNull();
            }
            case 6: {
                return DERObjectIdentifier.parse(encoded, lo[0], offset + 1 + lo[1]);
            }
            case 10: {
                break;
            }
            case 12: {
                break;
            }
            case 16: {
                return DERSequence.parse(encoded, lo[0], offset + 1 + lo[1]);
            }
            case 17: {
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                break;
            }
            case 22: {
                break;
            }
            case 23: {
                break;
            }
            case 26: {
                break;
            }
            case 27: {
                break;
            }
            case 28: {
                break;
            }
        }
        throw new IllegalArgumentException("Unsupported ASN.1 tag " + id);
    }
}

