/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.request;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.management.MalformedObjectNameException;
import org.jolokia.json.JSONArray;
import org.jolokia.json.JSONObject;
import org.jolokia.server.core.request.JolokiaConfigRequest;
import org.jolokia.server.core.request.JolokiaExecRequest;
import org.jolokia.server.core.request.JolokiaListRequest;
import org.jolokia.server.core.request.JolokiaNotificationRequest;
import org.jolokia.server.core.request.JolokiaReadRequest;
import org.jolokia.server.core.request.JolokiaRequest;
import org.jolokia.server.core.request.JolokiaSearchRequest;
import org.jolokia.server.core.request.JolokiaVersionRequest;
import org.jolokia.server.core.request.JolokiaWriteRequest;
import org.jolokia.server.core.request.ProcessingParameters;
import org.jolokia.server.core.request.RequestCreator;
import org.jolokia.server.core.util.EscapeUtil;
import org.jolokia.server.core.util.RequestType;

public final class JolokiaRequestFactory {
    private static final Map<RequestType, RequestCreator<?>> CREATOR_MAP = new HashMap();

    private JolokiaRequestFactory() {
    }

    public static <R extends JolokiaRequest> R createGetRequest(String pPathInfo, ProcessingParameters pProcessingParameters) {
        RequestType type = null;
        try {
            String pathInfo = JolokiaRequestFactory.extractPathInfo(pPathInfo, pProcessingParameters);
            Deque<String> elements = EscapeUtil.extractElementsFromPath(pathInfo);
            type = !elements.isEmpty() ? RequestType.getTypeByName(elements.pop()) : RequestType.VERSION;
            R creator = JolokiaRequestFactory.getCreator(type);
            return ((RequestCreator)creator).create(elements, pProcessingParameters);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid object name. " + e.getMessage(), e);
        }
        catch (NoSuchElementException exp) {
            throw new IllegalArgumentException("Invalid arguments in pathinfo \"" + pPathInfo + "\"" + (String)(type != null ? " for command " + String.valueOf(type) : ""), exp);
        }
    }

    public static <R extends JolokiaRequest> R createPostRequest(JSONObject pRequestMap, ProcessingParameters pProcessingParams) {
        try {
            Object config = pRequestMap.get("config");
            ProcessingParameters paramsMerged = config instanceof JSONObject ? pProcessingParams.mergedParams((JSONObject)pRequestMap.get("config")) : pProcessingParams;
            RequestType type = RequestType.getTypeByName((String)pRequestMap.get("type"));
            R creator = JolokiaRequestFactory.getCreator(type);
            return ((RequestCreator)creator).create(pRequestMap, paramsMerged);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid object name. " + e.getMessage(), e);
        }
    }

    public static List<JolokiaRequest> createPostRequests(JSONArray pJsonRequests, ProcessingParameters pProcessingParams) {
        ArrayList<JolokiaRequest> ret = new ArrayList<JolokiaRequest>();
        for (Object o : pJsonRequests) {
            if (!(o instanceof JSONObject)) {
                throw new IllegalArgumentException("Not a request within the list of requests " + String.valueOf(pJsonRequests) + ". Expected JSONObject, but found: " + String.valueOf(o));
            }
            ret.add((JolokiaRequest)JolokiaRequestFactory.createPostRequest((JSONObject)o, pProcessingParams));
        }
        return ret;
    }

    private static String extractPathInfo(String pPathInfo, ProcessingParameters pProcessingParams) {
        String pathInfo = pPathInfo;
        if (pProcessingParams != null && (pPathInfo == null || pPathInfo.isEmpty() || pathInfo.matches("^/+$"))) {
            pathInfo = pProcessingParams.getPathInfo();
        }
        return JolokiaRequestFactory.normalizePathInfo(pathInfo);
    }

    private static String normalizePathInfo(String pPathInfo) {
        if (pPathInfo != null && !pPathInfo.isEmpty()) {
            return pPathInfo.startsWith("/") ? pPathInfo.substring(1) : pPathInfo;
        }
        return "";
    }

    private static <R extends RequestCreator<T>, T extends JolokiaRequest> R getCreator(RequestType pType) {
        RequestCreator<?> creator = CREATOR_MAP.get((Object)pType);
        if (creator == null) {
            throw new UnsupportedOperationException("Type " + String.valueOf((Object)pType) + " is not supported (yet)");
        }
        return (R)creator;
    }

    static {
        CREATOR_MAP.put(RequestType.READ, JolokiaReadRequest.newCreator());
        CREATOR_MAP.put(RequestType.WRITE, JolokiaWriteRequest.newCreator());
        CREATOR_MAP.put(RequestType.EXEC, JolokiaExecRequest.newCreator());
        CREATOR_MAP.put(RequestType.LIST, JolokiaListRequest.newCreator());
        CREATOR_MAP.put(RequestType.VERSION, JolokiaVersionRequest.newCreator());
        CREATOR_MAP.put(RequestType.SEARCH, JolokiaSearchRequest.newCreator());
        CREATOR_MAP.put(RequestType.NOTIFICATION, JolokiaNotificationRequest.newCreator());
        CREATOR_MAP.put(RequestType.CONFIG, JolokiaConfigRequest.newCreator());
    }
}

