/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.serializer.object;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.ParseException;
import java.time.Instant;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jolokia.json.JSONArray;
import org.jolokia.json.JSONObject;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.util.ClassUtil;
import org.jolokia.server.core.util.DateUtil;
import org.jolokia.server.core.util.EscapeUtil;
import org.jolokia.service.serializer.json.DateFormatConfiguration;
import org.jolokia.service.serializer.json.ObjectAccessor;
import org.jolokia.service.serializer.object.Converter;

public class ObjectToObjectConverter
implements Converter<String> {
    private static final Map<String, Class<?>> TYPE_SIGNATURE_MAP = new HashMap();
    private static final Map<String, Class<?>> PRIMITIVE_TYPE_MAP = new HashMap();
    private static final Map<String, Parser> PARSER_MAP = new HashMap<String, Parser>();
    private static final StringParser stringParser;
    private static final DateParser dateParser;
    private static final CalendarParser calendarParser;
    private static final TemporalParser temporalParser;
    private static final BigDecimal MIN_FLOAT;
    private static final BigDecimal MAX_FLOAT;
    private static final BigDecimal MIN_DOUBLE;
    private static final BigDecimal MAX_DOUBLE;

    public ObjectToObjectConverter() {
        this.setJolokiaContext(null);
    }

    public void setJolokiaContext(JolokiaContext pJolokiaContext) {
        DateFormatConfiguration dateFormatConfiguration = new DateFormatConfiguration(pJolokiaContext);
        stringParser.setDateFormatConfiguration(dateFormatConfiguration);
        dateParser.setDateFormatConfiguration(dateFormatConfiguration);
        calendarParser.setDateFormatConfiguration(dateFormatConfiguration);
        temporalParser.setDateFormatConfiguration(dateFormatConfiguration);
    }

    public void setStringConverters(Map<Class<?>, ObjectAccessor> stringConverters) {
        stringParser.setStringConverters(stringConverters);
    }

    @Override
    public Object convert(String pExpectedClassName, Object pValue) {
        if (pValue == null) {
            return null;
        }
        Class<Object> expectedClass = TYPE_SIGNATURE_MAP.containsKey(pExpectedClassName) ? TYPE_SIGNATURE_MAP.get(pExpectedClassName) : (PRIMITIVE_TYPE_MAP.containsKey(pExpectedClassName) ? PRIMITIVE_TYPE_MAP.get(pExpectedClassName) : ClassUtil.classForName(pExpectedClassName, new ClassLoader[0]));
        if (expectedClass == null) {
            throw new IllegalArgumentException("Cannot load a class of target type \"" + pExpectedClassName + "\"");
        }
        return this.convert(expectedClass, pValue);
    }

    @Override
    private Object convert(Class<?> pExpectedClass, Object pValue) {
        Class<?> wrapperClass;
        if (pExpectedClass.isAssignableFrom(pValue.getClass())) {
            if (pExpectedClass == String.class) {
                return EscapeUtil.convertSpecialStringTags((String)pValue);
            }
            return pValue;
        }
        if (Enum.class.isAssignableFrom(pExpectedClass)) {
            if (!(pValue instanceof String)) {
                throw new IllegalArgumentException("Cannot convert non-String values to enums");
            }
            return Enum.valueOf(pExpectedClass, (String)pValue);
        }
        if (pExpectedClass.isArray() && pValue instanceof Collection) {
            return this.convertCollectionToArray(pExpectedClass, (Collection)pValue);
        }
        if (pExpectedClass.isPrimitive() && (wrapperClass = PRIMITIVE_TYPE_MAP.get(pExpectedClass.getName())).isAssignableFrom(pValue.getClass())) {
            return pValue;
        }
        if (pValue.getClass() != String.class) {
            Parser parser = PARSER_MAP.get(pExpectedClass.getName());
            if (parser != null && parser.supports(pValue.getClass(), pValue)) {
                return parser.parse(pValue);
            }
            if (pExpectedClass.getPackage() == Instant.class.getPackage() && temporalParser.supports(pValue.getClass(), pValue)) {
                return temporalParser.extract(pExpectedClass, pValue);
            }
            Object result = this.convertByConstructor(pExpectedClass, pValue);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("Cannot convert a \"" + pValue.getClass().getName() + "\" value to \"" + pExpectedClass.getName() + "\"");
        }
        return this.convertFromString(pExpectedClass, (String)pValue);
    }

    private Object convertCollectionToArray(Class<?> pType, Collection<?> pList) {
        Class<?> valueType = pType.getComponentType();
        Object ret = Array.newInstance(valueType, pList.size());
        int i = 0;
        for (Object value : pList) {
            if (value == null) {
                if (!valueType.isPrimitive()) {
                    Array.set(ret, i++, null);
                    continue;
                }
                throw new IllegalArgumentException("Cannot use a null value in an array of type " + valueType.getSimpleName());
            }
            if (valueType.isAssignableFrom(value.getClass())) {
                Array.set(ret, i++, value);
                continue;
            }
            if (valueType.isArray() && value instanceof Collection) {
                Array.set(ret, i++, this.convertCollectionToArray(valueType, (Collection)value));
                continue;
            }
            Array.set(ret, i++, this.convert(valueType, value));
        }
        return ret;
    }

    Object convertFromString(String pType, String pValue) {
        if (pType.startsWith("[")) {
            Class arrayClass;
            if (pType.length() >= 2 && (arrayClass = ClassUtil.classForName(pType, new ClassLoader[0])) != null) {
                return this.convertFromString(arrayClass, pValue);
            }
            throw new IllegalArgumentException("Cannot load a class of target type \"" + pType + "\"");
        }
        Class<Object> type = TYPE_SIGNATURE_MAP.containsKey(pType) ? TYPE_SIGNATURE_MAP.get(pType) : ClassUtil.classForName(pType, new ClassLoader[0]);
        if (type == null) {
            type = PRIMITIVE_TYPE_MAP.get(pType);
        }
        if (type != null) {
            return this.convertFromString(type, pValue);
        }
        throw new IllegalArgumentException("Cannot load a class of target type \"" + pType + "\"");
    }

    Object convertFromString(Class<?> pType, String pValue) {
        String value = EscapeUtil.convertSpecialStringTags(pValue);
        if (value == null) {
            return null;
        }
        if (pType.isArray()) {
            return this.convertToArray(pType, pValue);
        }
        Parser parser = PARSER_MAP.get(pType.getName());
        if (parser != null) {
            return parser.parse(value);
        }
        if (pType.getPackage().getName().equals("java.time")) {
            return temporalParser.extract(pType, value);
        }
        Object cValue = this.convertByConstructor(pType, pValue);
        if (cValue != null) {
            return cValue;
        }
        throw new IllegalArgumentException("Cannot convert string " + value + " to type " + String.valueOf(pType) + " because no converter could be found");
    }

    private Object convertToArray(Class<?> pType, String pValue) {
        if (!pType.isArray()) {
            throw new IllegalArgumentException("Expected array Class, got " + pType.getName());
        }
        if (pType.getComponentType().isArray()) {
            throw new IllegalArgumentException("Can parse only single-dimensional arrays");
        }
        Class<?> valueType = pType.getComponentType();
        String[] values = EscapeUtil.splitAsArray(pValue, "!", ",");
        Object ret = Array.newInstance(valueType, values.length);
        int i = 0;
        for (String value : values) {
            Array.set(ret, i++, value.equals("[null]") ? null : this.convert(valueType, (Object)value));
        }
        return ret;
    }

    private Object convertByConstructor(Class<?> pType, Object pValue) {
        for (Constructor<?> constructor : pType.getConstructors()) {
            if (constructor.getParameterTypes().length != 1 || !constructor.getParameterTypes()[0].isAssignableFrom(pValue.getClass())) continue;
            try {
                return constructor.newInstance(pValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean noIntegerOverflow(Object pValue, Class<? extends Number> nClass, int bits, long minV, long maxV) {
        if (!(pValue instanceof Number)) {
            return false;
        }
        if (nClass == pValue.getClass()) {
            return true;
        }
        if (pValue instanceof BigInteger) {
            BigInteger bi = (BigInteger)pValue;
            return bi.bitLength() <= bits;
        }
        long v = ((Number)pValue).longValue();
        return v >= minV && v <= maxV;
    }

    static {
        MIN_FLOAT = new BigDecimal(-3.4028234663852886E38);
        MAX_FLOAT = new BigDecimal(3.4028234663852886E38);
        MIN_DOUBLE = new BigDecimal(-1.7976931348623157E308);
        MAX_DOUBLE = new BigDecimal(Double.MAX_VALUE);
        TYPE_SIGNATURE_MAP.put("Z", Boolean.TYPE);
        TYPE_SIGNATURE_MAP.put("C", Character.TYPE);
        TYPE_SIGNATURE_MAP.put("B", Byte.TYPE);
        TYPE_SIGNATURE_MAP.put("S", Short.TYPE);
        TYPE_SIGNATURE_MAP.put("I", Integer.TYPE);
        TYPE_SIGNATURE_MAP.put("J", Long.TYPE);
        TYPE_SIGNATURE_MAP.put("F", Float.TYPE);
        TYPE_SIGNATURE_MAP.put("D", Double.TYPE);
        PRIMITIVE_TYPE_MAP.put(Boolean.TYPE.getName(), Boolean.class);
        PRIMITIVE_TYPE_MAP.put(Character.TYPE.getName(), Character.class);
        PRIMITIVE_TYPE_MAP.put(Byte.TYPE.getName(), Byte.class);
        PRIMITIVE_TYPE_MAP.put(Short.TYPE.getName(), Short.class);
        PRIMITIVE_TYPE_MAP.put(Integer.TYPE.getName(), Integer.class);
        PRIMITIVE_TYPE_MAP.put(Long.TYPE.getName(), Long.class);
        PRIMITIVE_TYPE_MAP.put(Float.TYPE.getName(), Float.class);
        PRIMITIVE_TYPE_MAP.put(Double.TYPE.getName(), Double.class);
        BooleanParser booleanParser = new BooleanParser();
        PARSER_MAP.put(Boolean.class.getName(), booleanParser);
        PARSER_MAP.put("boolean", booleanParser);
        CharacterParser characterParser = new CharacterParser();
        PARSER_MAP.put(Character.class.getName(), characterParser);
        PARSER_MAP.put("char", characterParser);
        ByteParser byteParser = new ByteParser();
        PARSER_MAP.put(Byte.class.getName(), byteParser);
        PARSER_MAP.put("byte", byteParser);
        ShortParser shortParser = new ShortParser();
        PARSER_MAP.put(Short.class.getName(), shortParser);
        PARSER_MAP.put("short", shortParser);
        IntegerParser integerParser = new IntegerParser();
        PARSER_MAP.put(Integer.class.getName(), integerParser);
        PARSER_MAP.put("int", integerParser);
        LongParser longParser = new LongParser();
        PARSER_MAP.put(Long.class.getName(), longParser);
        PARSER_MAP.put("long", longParser);
        FloatParser floatParser = new FloatParser();
        PARSER_MAP.put(Float.class.getName(), floatParser);
        PARSER_MAP.put("float", floatParser);
        DoubleParser doubleParser = new DoubleParser();
        PARSER_MAP.put(Double.class.getName(), doubleParser);
        PARSER_MAP.put("double", doubleParser);
        stringParser = new StringParser();
        PARSER_MAP.put(String.class.getName(), stringParser);
        PARSER_MAP.put(BigDecimal.class.getName(), new BigDecimalParser());
        PARSER_MAP.put(BigInteger.class.getName(), new BigIntegerParser());
        dateParser = new DateParser();
        PARSER_MAP.put(Date.class.getName(), dateParser);
        PARSER_MAP.put(ObjectName.class.getName(), new ObjectNameParser());
        PARSER_MAP.put(URL.class.getName(), new URLParser());
        PARSER_MAP.put(URI.class.getName(), new URIParser());
        calendarParser = new CalendarParser();
        PARSER_MAP.put(Calendar.class.getName(), calendarParser);
        JSONParser jsonParser = new JSONParser();
        PARSER_MAP.put(List.class.getName(), jsonParser);
        PARSER_MAP.put(JSONArray.class.getName(), jsonParser);
        PARSER_MAP.put(Map.class.getName(), jsonParser);
        PARSER_MAP.put(JSONObject.class.getName(), jsonParser);
        temporalParser = new TemporalParser();
    }

    private static class StringParser
    implements Parser,
    DateFormatConfigurationAware {
        private static final Set<Class<?>> KNOWN_TO_STRING = Collections.synchronizedSet(new HashSet());
        private static final Set<Class<?>> UNDESIRED_TO_STRING = new HashSet();
        private static final Map<Class<?>, ObjectAccessor> ACCESSORS = new HashMap();
        private static final Map<Class<?>, ObjectAccessor> ALL_ACCESSORS = Collections.synchronizedMap(new HashMap());
        private DateFormatConfiguration dateFormatConfiguration = new DateFormatConfiguration();

        @Override
        public void setDateFormatConfiguration(DateFormatConfiguration configuration) {
            this.dateFormatConfiguration = configuration;
        }

        public void setStringConverters(Map<Class<?>, ObjectAccessor> accessors) {
            ACCESSORS.putAll(accessors);
            ALL_ACCESSORS.putAll(accessors);
        }

        @Override
        public Object parse(String pValue) {
            return pValue;
        }

        @Override
        public Object parse(Object pValue) {
            ObjectAccessor accessor = ALL_ACCESSORS.get(pValue.getClass());
            if (accessor != null) {
                return accessor.extractString(pValue);
            }
            if (KNOWN_TO_STRING.contains(pValue.getClass())) {
                return pValue.toString();
            }
            throw new IllegalArgumentException("Can't convert " + pValue.getClass().getName() + " to String");
        }

        @Override
        public boolean supports(Class<?> pValueClass, Object pValue) {
            if (KNOWN_TO_STRING.contains(pValueClass) || ALL_ACCESSORS.containsKey(pValueClass)) {
                return true;
            }
            for (Map.Entry<Class<?>, ObjectAccessor> entry : ACCESSORS.entrySet()) {
                Class<?> c = entry.getKey();
                ObjectAccessor accessor = entry.getValue();
                if (!c.isAssignableFrom(pValueClass)) continue;
                ALL_ACCESSORS.put(pValueClass, accessor);
                return true;
            }
            if (!UNDESIRED_TO_STRING.contains(pValueClass)) {
                try {
                    Method toString = pValueClass.getMethod("toString", new Class[0]);
                    if (toString.getDeclaringClass() != Object.class) {
                        KNOWN_TO_STRING.add(pValueClass);
                        return true;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            return false;
        }

        static {
            KNOWN_TO_STRING.add(Boolean.class);
            KNOWN_TO_STRING.add(Character.class);
            KNOWN_TO_STRING.add(Byte.class);
            KNOWN_TO_STRING.add(Short.class);
            KNOWN_TO_STRING.add(Integer.class);
            KNOWN_TO_STRING.add(Long.class);
            KNOWN_TO_STRING.add(Float.class);
            KNOWN_TO_STRING.add(Double.class);
            KNOWN_TO_STRING.add(BigInteger.class);
            KNOWN_TO_STRING.add(BigDecimal.class);
            UNDESIRED_TO_STRING.add(Date.class);
            KNOWN_TO_STRING.add(Locale.class);
            KNOWN_TO_STRING.add(UUID.class);
        }
    }

    private static class DateParser
    implements Parser,
    DateFormatConfigurationAware {
        private DateFormatConfiguration dateFormatConfiguration;

        private DateParser() {
        }

        @Override
        public void setDateFormatConfiguration(DateFormatConfiguration configuration) {
            this.dateFormatConfiguration = configuration;
        }

        /*
         * Loose catch block
         */
        @Override
        public Object parse(String pValue) {
            block6: {
                if (!this.dateFormatConfiguration.usesUnixTime()) break block6;
                Long v = Long.parseLong(pValue);
                return this.dateFormatConfiguration.unixTimeToDate(v);
                {
                    catch (NumberFormatException | ParseException exp) {
                        return DateUtil.fromISO8601(pValue);
                    }
                }
            }
            try {
                return this.dateFormatConfiguration.unixTimeInMillisToDate(Long.parseLong(pValue));
            }
            catch (NumberFormatException e) {
                return this.dateFormatConfiguration.parseAsDate(pValue);
            }
        }
    }

    private static class CalendarParser
    implements Parser,
    DateFormatConfigurationAware {
        private DateFormatConfiguration dateFormatConfiguration;

        private CalendarParser() {
        }

        @Override
        public void setDateFormatConfiguration(DateFormatConfiguration configuration) {
            this.dateFormatConfiguration = configuration;
        }

        /*
         * Loose catch block
         */
        @Override
        public Object parse(String pValue) {
            block6: {
                if (!this.dateFormatConfiguration.usesUnixTime()) break block6;
                Long v = Long.parseLong(pValue);
                Date date = this.dateFormatConfiguration.unixTimeToDate(v);
                Calendar result = Calendar.getInstance();
                result.setTime(date);
                return result;
                {
                    catch (NumberFormatException | ParseException exp) {
                        date = DateUtil.fromISO8601(pValue);
                        result = Calendar.getInstance();
                        result.setTime(date);
                        return result;
                    }
                }
            }
            try {
                Date date = this.dateFormatConfiguration.unixTimeInMillisToDate(Long.parseLong(pValue));
                Calendar result = Calendar.getInstance();
                result.setTime(date);
                return result;
            }
            catch (NumberFormatException e) {
                Date date = this.dateFormatConfiguration.parseAsDate(pValue);
                Calendar result = Calendar.getInstance();
                result.setTime(date);
                return result;
            }
        }
    }

    private static class TemporalParser
    implements DateFormatConfigurationAware {
        private DateFormatConfiguration dateFormatConfiguration;

        private TemporalParser() {
        }

        @Override
        public void setDateFormatConfiguration(DateFormatConfiguration configuration) {
            this.dateFormatConfiguration = configuration;
        }

        /*
         * Loose catch block
         */
        public Object extract(Class<?> temporalType, String pValue) {
            block5: {
                if (!this.dateFormatConfiguration.usesUnixTime()) break block5;
                Long v = Long.parseLong(pValue);
                return this.dateFormatConfiguration.unixTimeToTemporal(temporalType, v);
                {
                    catch (NumberFormatException exp) {
                        throw new IllegalArgumentException("Cannot create " + String.valueOf(temporalType) + " from \"" + pValue + "\"");
                    }
                }
            }
            try {
                return this.dateFormatConfiguration.unixTimeInNanosToTemporal(temporalType, Long.parseLong(pValue));
            }
            catch (NumberFormatException e) {
                return this.dateFormatConfiguration.parseAsTemporal(temporalType, pValue);
            }
        }

        public Object extract(Class<?> temporalType, Object pValue) {
            if (pValue instanceof Number) {
                if (this.dateFormatConfiguration.usesUnixTime()) {
                    return this.dateFormatConfiguration.unixTimeToTemporal(temporalType, ((Number)pValue).longValue());
                }
                return this.dateFormatConfiguration.unixTimeInNanosToTemporal(temporalType, ((Number)pValue).longValue());
            }
            if (pValue instanceof String) {
                return this.extract(temporalType, (String)pValue);
            }
            throw new IllegalArgumentException("Cannot handle Temporal of class \"" + String.valueOf(temporalType) + "\" for value " + String.valueOf(pValue));
        }

        public boolean supports(Class<?> pValueClass, Object pValue) {
            return ObjectToObjectConverter.noIntegerOverflow(pValue, Long.class, 63, Long.MIN_VALUE, Long.MAX_VALUE);
        }
    }

    private static interface Parser {
        public Object parse(String var1);

        default public Object parse(Object pValue) {
            return null;
        }

        default public boolean supports(Class<?> pValueClass, Object pValue) {
            return false;
        }
    }

    private static class BooleanParser
    implements Parser {
        private BooleanParser() {
        }

        @Override
        public Object parse(String pValue) {
            return Boolean.parseBoolean(pValue);
        }
    }

    private static class CharacterParser
    implements Parser {
        private CharacterParser() {
        }

        @Override
        public Object parse(String pValue) {
            return Character.valueOf(pValue.charAt(0));
        }
    }

    private static class ByteParser
    implements Parser {
        private ByteParser() {
        }

        @Override
        public Object parse(String pValue) {
            return Byte.parseByte(pValue);
        }

        @Override
        public Object parse(Object pValue) {
            return ((Number)pValue).byteValue();
        }

        @Override
        public boolean supports(Class<?> pValueClass, Object pValue) {
            return ObjectToObjectConverter.noIntegerOverflow(pValue, Byte.class, 7, -128L, 127L);
        }
    }

    private static class ShortParser
    implements Parser {
        private ShortParser() {
        }

        @Override
        public Object parse(String pValue) {
            return Short.parseShort(pValue);
        }

        @Override
        public Object parse(Object pValue) {
            return ((Number)pValue).shortValue();
        }

        @Override
        public boolean supports(Class<?> pValueClass, Object pValue) {
            return ObjectToObjectConverter.noIntegerOverflow(pValue, Short.class, 15, -32768L, 32767L);
        }
    }

    private static class IntegerParser
    implements Parser {
        private IntegerParser() {
        }

        @Override
        public Object parse(String pValue) {
            return Integer.parseInt(pValue);
        }

        @Override
        public Object parse(Object pValue) {
            return ((Number)pValue).intValue();
        }

        @Override
        public boolean supports(Class<?> pValueClass, Object pValue) {
            return ObjectToObjectConverter.noIntegerOverflow(pValue, Integer.class, 31, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }
    }

    private static class LongParser
    implements Parser {
        private LongParser() {
        }

        @Override
        public Object parse(String pValue) {
            return Long.parseLong(pValue);
        }

        @Override
        public Object parse(Object pValue) {
            return ((Number)pValue).longValue();
        }

        @Override
        public boolean supports(Class<?> pValueClass, Object pValue) {
            return ObjectToObjectConverter.noIntegerOverflow(pValue, Long.class, 63, Long.MIN_VALUE, Long.MAX_VALUE);
        }
    }

    private static class FloatParser
    implements Parser {
        private FloatParser() {
        }

        @Override
        public Object parse(String pValue) {
            return Float.valueOf(Float.parseFloat(pValue));
        }

        @Override
        public Object parse(Object pValue) {
            return Float.valueOf(((Number)pValue).floatValue());
        }

        @Override
        public boolean supports(Class<?> pValueClass, Object pValue) {
            if (!(pValue instanceof Number)) {
                return false;
            }
            if (pValue.getClass() == Float.class) {
                return true;
            }
            if (pValue instanceof BigDecimal) {
                return ((BigDecimal)pValue).compareTo(MAX_FLOAT) >= 0 && ((BigDecimal)pValue).compareTo(MIN_FLOAT) >= 0;
            }
            if (pValue instanceof Double) {
                double v = (Double)pValue;
                return v >= (double)1.4E-45f && v <= 3.4028234663852886E38;
            }
            return false;
        }
    }

    private static class DoubleParser
    implements Parser {
        private DoubleParser() {
        }

        @Override
        public Object parse(String pValue) {
            return Double.parseDouble(pValue);
        }

        @Override
        public Object parse(Object pValue) {
            return ((Number)pValue).doubleValue();
        }

        @Override
        public boolean supports(Class<?> pValueClass, Object pValue) {
            if (!(pValue instanceof Number)) {
                return false;
            }
            if (pValue.getClass() == Double.class) {
                return true;
            }
            if (pValue instanceof BigDecimal) {
                return ((BigDecimal)pValue).compareTo(MAX_DOUBLE) <= 0 && ((BigDecimal)pValue).compareTo(MIN_DOUBLE) >= 0;
            }
            return pValue instanceof Float;
        }
    }

    private static class BigDecimalParser
    implements Parser {
        private BigDecimalParser() {
        }

        @Override
        public Object parse(String pValue) {
            return new BigDecimal(pValue);
        }

        @Override
        public Object parse(Object pValue) {
            Number n = (Number)pValue;
            if (n instanceof Float) {
                return new BigDecimal(Float.toString(((Float)n).floatValue()));
            }
            if (n instanceof Double) {
                return new BigDecimal(Double.toString((Double)n));
            }
            return new BigDecimal(n.toString());
        }

        @Override
        public boolean supports(Class<?> pValueClass, Object pValue) {
            return pValue instanceof Number;
        }
    }

    private static class BigIntegerParser
    implements Parser {
        private BigIntegerParser() {
        }

        @Override
        public Object parse(String pValue) {
            return new BigInteger(pValue);
        }
    }

    private static class ObjectNameParser
    implements Parser {
        private ObjectNameParser() {
        }

        @Override
        public Object parse(String pValue) {
            try {
                return new ObjectName(pValue);
            }
            catch (MalformedObjectNameException e) {
                throw new IllegalArgumentException("Cannot parse ObjectName " + pValue + ": " + e.getMessage(), e);
            }
        }
    }

    private static class URLParser
    implements Parser {
        private URLParser() {
        }

        @Override
        public Object parse(String pValue) {
            try {
                return new URL(pValue);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Cannot parse URL " + pValue + ": " + String.valueOf(e), e);
            }
        }
    }

    private static class URIParser
    implements Parser {
        private URIParser() {
        }

        @Override
        public Object parse(String pValue) {
            return URI.create(pValue);
        }
    }

    private static class JSONParser
    implements Parser {
        private JSONParser() {
        }

        @Override
        public Object parse(String pValue) {
            try {
                return new org.jolokia.json.parser.JSONParser().parse(pValue);
            }
            catch (IOException | org.jolokia.json.parser.ParseException e) {
                throw new IllegalArgumentException("Cannot parse JSON " + pValue + ": " + String.valueOf(e), e);
            }
        }
    }

    private static interface DateFormatConfigurationAware {
        public void setDateFormatConfiguration(DateFormatConfiguration var1);
    }
}

