/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.proxy;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaObject;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Java::JavaProxyClass"})
public class JavaProxyReflectionObject
extends RubyObject {
    public JavaProxyReflectionObject(Ruby runtime2, RubyClass metaClass) {
        super(runtime2, metaClass, false);
    }

    protected static void registerRubyMethods(Ruby runtime2, RubyClass klass) {
        klass.defineAnnotatedMethods(JavaProxyReflectionObject.class);
        klass.getMetaClass().defineAlias("__j_allocate", "allocate");
    }

    @Deprecated
    public IRubyObject op_equal(IRubyObject other) {
        return this.op_eqq(this.getRuntime().getCurrentContext(), other);
    }

    @Override
    @JRubyMethod(name={"==", "eql?"})
    public RubyBoolean op_eqq(ThreadContext context, IRubyObject obj) {
        if (!(obj instanceof JavaProxyReflectionObject)) {
            Object wrappedObj = obj.dataGetStruct();
            if (!(wrappedObj instanceof JavaObject)) {
                return context.fals;
            }
            obj = (IRubyObject)wrappedObj;
        }
        return RubyBoolean.newBoolean(context, this.equals(obj));
    }

    @Deprecated
    public IRubyObject same(IRubyObject other) {
        return this.op_equal(this.getRuntime().getCurrentContext(), other);
    }

    @Override
    @JRubyMethod(name={"equal?"})
    public RubyBoolean op_equal(ThreadContext context, IRubyObject obj) {
        if (this == obj) {
            return context.tru;
        }
        if (!(obj instanceof JavaProxyReflectionObject)) {
            Object wrappedObj = obj.dataGetStruct();
            if (!(wrappedObj instanceof JavaObject)) {
                return context.fals;
            }
            obj = (IRubyObject)wrappedObj;
        }
        return RubyBoolean.newBoolean(context, this == obj);
    }

    @Override
    public boolean equals(Object other) {
        return this == other;
    }

    @Override
    @JRubyMethod
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.hashCode());
    }

    @Override
    public int hashCode() {
        return 11 * this.getJavaClass().hashCode();
    }

    @Override
    @JRubyMethod
    public IRubyObject to_s() {
        return this.getRuntime().newString(this.toString());
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    @JRubyMethod
    public RubyString java_type() {
        return this.getRuntime().newString(this.getJavaClass().getName());
    }

    @JRubyMethod
    public IRubyObject java_class() {
        return Java.getInstance(this.getRuntime(), this.getJavaClass());
    }

    @JRubyMethod
    public RubyFixnum length() {
        throw this.getRuntime().newTypeError("not a java array");
    }

    @JRubyMethod(name={"[]"})
    public IRubyObject aref(IRubyObject index2) {
        throw this.getRuntime().newTypeError("not a java array");
    }

    @JRubyMethod(name={"[]="})
    public IRubyObject aset(IRubyObject index2, IRubyObject someValue) {
        throw this.getRuntime().newTypeError("not a java array");
    }

    @JRubyMethod(name={"java_proxy?"})
    public IRubyObject is_java_proxy() {
        return this.getRuntime().getFalse();
    }

    final RubyArray toRubyArray(IRubyObject[] elements) {
        return RubyArray.newArrayMayCopy(this.getRuntime(), elements);
    }

    static RubyArray toClassArray(Ruby runtime2, Class<?>[] classes2) {
        IRubyObject[] javaClasses = new IRubyObject[classes2.length];
        int i2 = classes2.length;
        while (--i2 >= 0) {
            javaClasses[i2] = Java.getProxyClass(runtime2, classes2[i2]);
        }
        return RubyArray.newArrayMayCopy(runtime2, javaClasses);
    }
}

