/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.ruby.script;

import de.saumya.mojo.ruby.Logger;
import de.saumya.mojo.ruby.script.AbstractLauncher;
import de.saumya.mojo.ruby.script.AntLogAdapter;
import de.saumya.mojo.ruby.script.ScriptException;
import de.saumya.mojo.ruby.script.ScriptFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;

class AntLauncher
extends AbstractLauncher {
    private static final String MAVEN_CLASSPATH = "maven.classpath";
    private static final String DEFAULT_XMX = "-Xmx384m";
    private static final String TEMP_FILE_PREFIX = "jruby-ant-launcher-";
    private final Logger logger;
    private final ScriptFactory factory;
    private final Project project;

    AntLauncher(Logger logger, ScriptFactory factory) {
        this.logger = logger;
        this.factory = factory;
        this.project = this.createAntProject();
    }

    @Override
    protected void doExecute(File launchDirectory, List<String> args, File outputFile) throws ScriptException, IOException {
        this.doExecute(launchDirectory, args, new FileOutputStream(outputFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected void doExecute(File launchDirectory, List<String> args, OutputStream outputStream) throws ScriptException, IOException {
        Java java = new Java();
        java.setProject(this.project);
        java.setClassname("org.jruby.Main");
        java.setFailonerror(true);
        java.setFork(true);
        java.setDir(launchDirectory);
        for (Map.Entry<String, String> entry : this.factory.environment().entrySet()) {
            Environment.Variable v = new Environment.Variable();
            v.setKey(entry.getKey());
            v.setValue(entry.getValue());
            java.addEnv(v);
        }
        this.logger.debug("java classpath  : " + this.project.getReference(MAVEN_CLASSPATH));
        if (this.factory.environment().size() > 0) {
            this.logger.debug("environment     :");
            for (Map.Entry entry : this.factory.environment().entrySet()) {
                this.logger.debug("\t\t" + (String)entry.getKey() + " => " + (String)entry.getValue());
            }
        }
        for (String string : this.factory.switches.list) {
            java.createArg().setValue(string);
        }
        for (String string : args) {
            java.createArg().setValue(string);
        }
        Path temp = (Path)this.project.getReference(MAVEN_CLASSPATH);
        if (this.factory.jrubyJar != null) {
            temp.add(new Path(this.project, this.factory.jrubyJar.getAbsolutePath()));
        }
        java.createJvmarg().setLine("-XX:+IgnoreUnrecognizedVMOptions --add-opens=java.base/java.security.cert=ALL-UNNAMED --add-opens=java.base/java.security=ALL-UNNAMED --add-opens=java.base/java.util.zip=ALL-UNNAMED --add-opens=java.base/java.lang.reflect=ALL-UNNAMED --add-opens=java.base/javax.crypto=ALL-UNNAMED --illegal-access=warn");
        java.createJvmarg().setValue("-cp");
        java.createJvmarg().setPath(temp);
        for (String arg : this.factory.jvmArgs.list) {
            java.createJvmarg().setValue(arg);
        }
        if (this.factory.jrubyJar != null && this.factory.jrubyJar.equals(this.factory.jrubyStdlibJar)) {
            java.createJvmarg().setValue("-Xbootclasspath/a:" + this.factory.jrubyJar.getAbsolutePath());
        }
        if (this.factory.jrubyJar == null && System.getProperty("jruby.home") != null) {
            Environment.Variable variable = new Environment.Variable();
            variable.setKey("jruby.home");
            variable.setValue(System.getProperty("jruby.home"));
            java.addSysproperty(variable);
            File lib = System.getProperty("jruby.lib") != null ? new File(System.getProperty("jruby.lib")) : new File(System.getProperty("jruby.home"), "lib");
            File jrubyJar = new File(lib, "jruby.jar");
            java.createJvmarg().setValue("-Xbootclasspath/a:" + jrubyJar.getAbsolutePath());
        }
        Object var6_16 = null;
        if (outputStream != null) {
            File file = File.createTempFile(TEMP_FILE_PREFIX, ".output");
            java.setOutput(file);
        }
        java.setLogError(true);
        File errorTempFile = null;
        try {
            errorTempFile = File.createTempFile(TEMP_FILE_PREFIX, ".log");
            errorTempFile.deleteOnExit();
            java.setError(errorTempFile);
            java.execute();
            if (outputStream != null) {
                void var6_18;
                this.writeInto((File)var6_18, outputStream);
                var6_18.delete();
            }
        }
        catch (IOException e) {
            this.logger.warn("can not create tempfile for stderr");
            java.execute();
        }
        finally {
            if (errorTempFile != null && errorTempFile.length() > 0L) {
                try {
                    byte[] encoded = Files.readAllBytes(errorTempFile.toPath());
                    this.logger.warn(new String(encoded));
                }
                catch (IOException e) {
                    this.logger.warn("can not read error file");
                }
                errorTempFile.delete();
            }
        }
    }

    private void writeInto(File file, OutputStream outputStream) throws IOException {
        byte[] buffer = new byte[4096];
        FileInputStream fileIS = new FileInputStream(file);
        int read = 0;
        while ((read = ((InputStream)fileIS).read(buffer)) > 0) {
            outputStream.write(buffer, 0, read);
        }
    }

    private Project createAntProject() {
        Project project = new Project();
        Path classPath = new Path(project);
        for (String path : this.factory.classpathElements) {
            if (path.contains("jruby-complete") && this.factory.jrubyJar != null) continue;
            classPath.add(new Path(project, path));
        }
        project.addReference(MAVEN_CLASSPATH, (Object)classPath);
        project.addBuildListener((BuildListener)new AntLogAdapter(this.logger));
        return project;
    }

    @Override
    public void execute(List<String> args) throws ScriptException, IOException {
        this.doExecute(null, args, (OutputStream)null);
    }

    @Override
    public void execute(List<String> args, File outputFile) throws ScriptException, IOException {
        this.doExecute(null, args, outputFile);
    }

    @Override
    public void executeIn(File launchDirectory, List<String> args) throws ScriptException, IOException {
        this.doExecute(launchDirectory, args, (OutputStream)null);
    }

    @Override
    public void executeIn(File launchDirectory, List<String> args, File outputFile) throws ScriptException, IOException {
        this.doExecute(launchDirectory, args, outputFile);
    }

    @Override
    public void executeScript(String script, List<String> args) throws ScriptException, IOException {
        this.executeScript(script, args, (OutputStream)null);
    }

    @Override
    public void executeScript(String script, List<String> args, File outputFile) throws ScriptException, IOException {
        this.executeScript(null, script, args, outputFile);
    }

    @Override
    public void executeScript(File launchDirectory, String script, List<String> args) throws ScriptException, IOException {
        this.executeScript(launchDirectory, script, args, (OutputStream)null);
    }

    @Override
    public void executeScript(File launchDirectory, String script, List<String> args, File outputFile) throws ScriptException, IOException {
        this.addScriptArguments(script, args);
        this.doExecute(launchDirectory, args, outputFile);
    }

    @Override
    public void executeScript(File launchDirectory, String script, List<String> args, OutputStream outputStream) throws ScriptException, IOException {
        this.addScriptArguments(script, args);
        this.doExecute(launchDirectory, args, outputStream);
    }

    private void addScriptArguments(String script, List<String> args) {
        args.add(0, "-e");
        args.add(1, script);
        args.add(2, "--");
    }
}

