/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.jelly;

import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.Tag;
import org.apache.commons.jelly.TagLibrary;
import org.apache.commons.jelly.impl.TagScript;
import org.kohsuke.stapler.MetaClass;
import org.kohsuke.stapler.MetaClassLoader;
import org.kohsuke.stapler.jelly.CallTagLibScript;
import org.kohsuke.stapler.jelly.CustomJellyContext;
import org.kohsuke.stapler.jelly.JellyTagFileLoader;
import org.xml.sax.Attributes;

public final class CustomTagLibrary
extends TagLibrary {
    private final JellyContext master;
    private final ClassLoader classLoader;
    public final MetaClassLoader metaClassLoader;
    public final String nsUri;
    public final String basePath;
    private final Map<String, Script> scripts = new Hashtable<String, Script>();
    private final List<JellyTagFileLoader> loaders;

    public CustomTagLibrary(JellyContext master, ClassLoader classLoader, String nsUri, String basePath) {
        this.master = master;
        this.classLoader = classLoader;
        this.nsUri = nsUri;
        this.basePath = basePath;
        this.metaClassLoader = MetaClassLoader.get((ClassLoader)classLoader);
        this.loaders = JellyTagFileLoader.discover(classLoader);
    }

    public TagScript createTagScript(String name, Attributes attributes) throws JellyException {
        final Script def = this.load(name);
        if (def == null) {
            return null;
        }
        return new CallTagLibScript(){

            @Override
            protected Script resolveDefinition(JellyContext context) {
                return def;
            }
        };
    }

    public Tag createTag(String name, Attributes attributes) throws JellyException {
        return null;
    }

    private Script load(String name) throws JellyException {
        Script script = this.scripts.get(name);
        if (script != null && !MetaClass.NO_CACHE) {
            return script;
        }
        script = null;
        if (MetaClassLoader.debugLoader != null) {
            script = this.load(name, MetaClassLoader.debugLoader.loader);
        }
        if (script == null) {
            script = this.load(name, this.classLoader);
        }
        return script;
    }

    private Script load(String name, ClassLoader classLoader) throws JellyException {
        URL res = classLoader.getResource(this.basePath + "/" + name + ".jellytag");
        if (res == null) {
            res = classLoader.getResource(this.basePath + "/" + name + ".jelly");
        }
        if (res != null) {
            Script script = this.loadJellyScript(res);
            this.scripts.put(name, script);
            return script;
        }
        for (JellyTagFileLoader loader : this.loaders) {
            Script s = loader.load(this, name, classLoader);
            if (s == null) continue;
            this.scripts.put(name, s);
            return s;
        }
        return null;
    }

    private Script loadJellyScript(URL res) throws JellyException {
        CustomJellyContext context = new CustomJellyContext(this.master);
        context.setClassLoader(this.classLoader);
        return context.compileScript(res);
    }
}

