/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.jelly;

import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.TagLibrary;
import org.apache.commons.jelly.expression.ExpressionFactory;
import org.apache.commons.jelly.expression.jexl.JexlExpressionFactory;
import org.kohsuke.stapler.MetaClassLoader;
import org.kohsuke.stapler.jelly.CustomJellyContext;
import org.kohsuke.stapler.jelly.CustomTagLibrary;
import org.kohsuke.stapler.jelly.StaplerTagLibrary;
import org.kohsuke.stapler.jelly.ThisTagLibrary;

public class JellyClassLoaderTearOff {
    private final MetaClassLoader owner;
    private volatile WeakReference<ConcurrentMap<String, TagLibrary>> taglibs;
    static ExpressionFactory EXPRESSION_FACTORY = new JexlExpressionFactory();
    private static final JellyContext ROOT_CONTEXT = new CustomJellyContext();
    private static final TagLibrary NO_SUCH_TAGLIBRARY = new TagLibrary(){};

    public JellyClassLoaderTearOff(MetaClassLoader owner) {
        this.owner = owner;
    }

    public TagLibrary getTagLibrary(String nsUri) {
        TagLibrary tl;
        ConcurrentHashMap<String, TagLibrary> m = null;
        if (this.taglibs != null) {
            m = (ConcurrentHashMap<String, TagLibrary>)this.taglibs.get();
        }
        if (m == null) {
            m = new ConcurrentHashMap<String, TagLibrary>();
            this.taglibs = new WeakReference(m);
        }
        if ((tl = m.computeIfAbsent(nsUri, key -> {
            TagLibrary taglib;
            if (this.owner.parent != null && (taglib = ((JellyClassLoaderTearOff)this.owner.parent.loadTearOff(JellyClassLoaderTearOff.class)).getTagLibrary(nsUri)) != null) {
                return taglib;
            }
            String taglibBasePath = this.trimHeadSlash(nsUri);
            try {
                URL res = this.owner.loader.getResource(taglibBasePath + "/taglib");
                if (res != null) {
                    return new CustomTagLibrary(this.createContext(), this.owner.loader, nsUri, taglibBasePath);
                }
            }
            catch (IllegalArgumentException res) {
                // empty catch block
            }
            if (nsUri.startsWith("this:")) {
                try {
                    return new ThisTagLibrary(EXPRESSION_FACTORY.createExpression(nsUri.substring(5)));
                }
                catch (JellyException e) {
                    throw new IllegalArgumentException("Illegal expression in the URI: " + nsUri, e);
                }
            }
            if (nsUri.equals("jelly:stapler")) {
                return new StaplerTagLibrary();
            }
            return NO_SUCH_TAGLIBRARY;
        })) == NO_SUCH_TAGLIBRARY) {
            return null;
        }
        return tl;
    }

    private String trimHeadSlash(String nsUri) {
        if (nsUri.startsWith("/")) {
            return nsUri.substring(1);
        }
        return nsUri;
    }

    public JellyContext createContext() {
        CustomJellyContext context = new CustomJellyContext(ROOT_CONTEXT);
        context.setClassLoader(this.owner.loader);
        context.setExportLibraries(false);
        return context;
    }
}

