/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.wagon;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.maven.wagon.events.SessionEvent;
import org.apache.maven.wagon.events.SessionListener;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferListener;
import org.kuali.maven.wagon.SessionTracker;
import org.kuali.maven.wagon.SimpleFormatter;
import org.kuali.maven.wagon.TransferTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3Listener
implements TransferListener,
SessionListener {
    final Logger log = LoggerFactory.getLogger(S3Listener.class);
    SimpleFormatter formatter = new SimpleFormatter();
    SessionTracker sessionTracker = new SessionTracker();

    public void transferCompleted(TransferEvent transferEvent) {
        TransferTracker tt = this.sessionTracker.getCurrentTransfer();
        tt.setCompleted(System.currentTimeMillis());
    }

    public void transferError(TransferEvent transferEvent) {
        this.log.error("Transfer error: " + transferEvent.getException(), (Throwable)transferEvent.getException());
    }

    public void transferInitiated(TransferEvent transferEvent) {
        this.sessionTracker.addTransfer(new TransferTracker());
        TransferTracker tt = this.sessionTracker.getCurrentTransfer();
        tt.setInitiated(System.currentTimeMillis());
    }

    public void transferProgress(TransferEvent transferEvent, byte[] buffer, int length) {
        if (length == -1) {
            return;
        }
        TransferTracker tt = this.sessionTracker.getCurrentTransfer();
        int byteCount = tt.getByteCount() + length;
        tt.setByteCount(byteCount);
    }

    public void transferStarted(TransferEvent transferEvent) {
        TransferTracker tt = this.sessionTracker.getCurrentTransfer();
        tt.setStarted(System.currentTimeMillis());
        if (transferEvent.getRequestType() == 5) {
            this.log.info("Downloading: " + this.getURI(transferEvent));
        } else {
            this.log.info("Uploading: " + this.getURI(transferEvent));
        }
    }

    protected String getURI(TransferEvent event) {
        return this.getNormalizedURI(event.getWagon().getRepository().getUrl() + "/" + event.getResource().getName());
    }

    protected String getNormalizedURI(String uri) {
        try {
            URI rawUri = new URI(uri);
            return rawUri.normalize().toString();
        }
        catch (URISyntaxException e) {
            return uri;
        }
    }

    public void sessionOpening(SessionEvent sessionEvent) {
        this.sessionTracker.addSessionEvent(sessionEvent);
    }

    public void sessionOpened(SessionEvent sessionEvent) {
        this.sessionTracker.addSessionEvent(sessionEvent);
        this.sessionTracker.setOpened(System.currentTimeMillis());
    }

    public void sessionDisconnecting(SessionEvent sessionEvent) {
        this.sessionTracker.addSessionEvent(sessionEvent);
        this.sessionTracker.setDisconnecting(System.currentTimeMillis());
    }

    public void sessionDisconnected(SessionEvent sessionEvent) {
        this.sessionTracker.addSessionEvent(sessionEvent);
        this.sessionTracker.setDisconnected(System.currentTimeMillis());
        int transferCount = this.sessionTracker.getTransfers().size();
        long byteCount = 0L;
        for (TransferTracker tt : this.sessionTracker.getTransfers()) {
            byteCount += (long)tt.getByteCount();
        }
        long elapsed = this.sessionTracker.getDisconnected() - this.sessionTracker.getOpened();
        StringBuilder sb = new StringBuilder();
        sb.append("Transfers: " + transferCount);
        sb.append(" Time: " + this.formatter.getTime(elapsed));
        sb.append(" Amount: " + this.formatter.getSize(byteCount));
        sb.append(" Throughput: " + this.formatter.getRate(elapsed, byteCount));
        if (transferCount > 0) {
            this.log.info(sb.toString());
        }
    }

    public void sessionConnectionRefused(SessionEvent sessionEvent) {
        this.sessionTracker.addSessionEvent(sessionEvent);
        this.log.warn(sessionEvent.getWagon().getRepository().getUrl() + " - Connection refused");
    }

    public void sessionLoggedIn(SessionEvent sessionEvent) {
        this.sessionTracker.addSessionEvent(sessionEvent);
        this.sessionTracker.setLoggedIn(System.currentTimeMillis());
        this.log.info("Logged in - " + sessionEvent.getWagon().getRepository().getHost());
    }

    public void sessionLoggedOff(SessionEvent sessionEvent) {
        this.sessionTracker.addSessionEvent(sessionEvent);
        this.sessionTracker.setLoggedOff(System.currentTimeMillis());
        this.log.info("Logged off - " + sessionEvent.getWagon().getRepository().getHost());
    }

    public void sessionError(SessionEvent sessionEvent) {
        this.sessionTracker.addSessionEvent(sessionEvent);
        this.log.error("Session error: " + sessionEvent.getException(), (Throwable)sessionEvent.getException());
    }

    public void debug(String message) {
        this.log.debug(message);
    }
}

