/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.wagon;

import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.Upload;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3Utils {
    private static final int KILOBYTE = 1024;
    private static final int MEGABYTE = 0x100000;
    private static final int MULTI_PART_UPLOAD_THRESHOLD = 0x6400000;
    private static final Logger log = LoggerFactory.getLogger(S3Utils.class);

    public static final void upload(File file, PutObjectRequest request, AmazonS3Client client, TransferManager manager) {
        if (file.length() < 0x6400000L) {
            client.putObject(request);
        } else {
            log.debug("Blocking multi-part upload: " + file.getAbsolutePath());
            S3Utils.blockingMultiPartUpload(request, manager);
        }
    }

    public static final void blockingMultiPartUpload(PutObjectRequest request, TransferManager manager) {
        Upload upload = manager.upload(request);
        try {
            upload.waitForCompletion();
        }
        catch (Exception e) {
            throw new AmazonS3Exception("Unexpected error uploading file", e);
        }
    }
}

