/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class LazyInitializingMap<K, V> {
    private final Map<K, V> internalMap = new ConcurrentHashMap();
    private final Function<K, V> initializer;

    public LazyInitializingMap(Function<K, V> initializer) {
        this.initializer = Objects.requireNonNull(initializer, "initializer must not be null");
    }

    public V get(K key) {
        V value = this.internalMap.computeIfAbsent(key, this.initializer);
        if (value == null) {
            throw new NullPointerException("Initializer must not create a null value");
        }
        return value;
    }

    @CheckForNull
    public V getIfPresent(K key) {
        return this.internalMap.get(key);
    }

    public void clear() {
        this.internalMap.clear();
    }

    @CheckForNull
    public V remove(K key) {
        return this.internalMap.remove(key);
    }
}

