/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.util.handler;

import java.util.Objects;
import java.util.function.Consumer;

@FunctionalInterface
public interface Handler {
    public static final Handler NOP_HANDLER = () -> {};

    public void apply();

    default public Handler andThen(Handler after) {
        Objects.requireNonNull(after, "after must not be null");
        return () -> {
            this.apply();
            after.apply();
        };
    }

    default public Handler compose(Handler before) {
        Objects.requireNonNull(before, "before must not be null");
        return () -> {
            before.apply();
            this.apply();
        };
    }

    default public <T> Consumer<T> compose(Consumer<T> before) {
        Objects.requireNonNull(before, "before must not be null");
        return before.andThen((? super T t) -> this.apply());
    }
}

