/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.util.reflection.accessor;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaConversionException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.linkki.util.reflection.accessor.AbstractMethod;

final class InvokeMethod<T>
extends AbstractMethod<T, Consumer<T>> {
    InvokeMethod(Class<? extends T> boundClass, String propertyName, Supplier<Optional<Method>> methodSupplier) {
        super(boundClass, propertyName, methodSupplier);
    }

    public void invoke(T target) {
        ((Consumer)this.getMethodAsFunction()).accept(target);
    }

    @Override
    protected CallSite getCallSiteForFunction(MethodHandles.Lookup lookup, MethodHandle methodHandle) throws LambdaConversionException {
        return LambdaMetafactory.metafactory(lookup, "accept", MethodType.methodType(Consumer.class), MethodType.methodType(Void.TYPE, Object.class), methodHandle, this.wrap(methodHandle));
    }

    @Override
    protected Consumer<T> handleExceptionForMethodHandle(Consumer<T> methodAsFunction) {
        return o -> {
            try {
                methodAsFunction.accept(o);
            }
            catch (RuntimeException e) {
                throw this.errorCallingMethod(e).get();
            }
        };
    }

    @Override
    protected Consumer<T> fallbackReflectionCall(Method method) {
        return o -> {
            try {
                method.invoke(o, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw this.errorCallingMethod(e).get();
            }
        };
    }

    public String toString() {
        return "invoke method for " + this.getBoundClass().getName() + "#" + this.getPropertyName();
    }
}

