/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.tooling.apt.validator;

import java.util.Collection;
import java.util.Map;
import javax.annotation.processing.Messager;
import javax.tools.Diagnostic;
import org.linkki.tooling.apt.model.AptAttribute;
import org.linkki.tooling.apt.model.AptComponent;
import org.linkki.tooling.apt.model.AptComponentDeclaration;
import org.linkki.tooling.apt.model.AptModelObject;
import org.linkki.tooling.apt.model.AptPmo;
import org.linkki.tooling.apt.util.SuppressedWarningsUtils;
import org.linkki.tooling.apt.validator.MessageCodes;
import org.linkki.tooling.apt.validator.Messages;
import org.linkki.tooling.apt.validator.Severity;
import org.linkki.tooling.apt.validator.Validator;

@MessageCodes(value={"MISSING_MODEL_OBJECT", "IMPLICIT_MODEL_BINDING", "MISSING_MODEL_ATTRIBUTE"})
public class ModelBindingValidator
implements Validator {
    public static final String IMPLICIT_MODEL_BINDING = "IMPLICIT_MODEL_BINDING";
    public static final String MISSING_MODEL_ATTRIBUTE = "MISSING_MODEL_ATTRIBUTE";
    public static final String MISSING_MODEL_OBJECT = "MISSING_MODEL_OBJECT";
    private final Diagnostic.Kind missingModelObjectSeverity;
    private final Diagnostic.Kind missingModelAttributeSeverity;
    private final Diagnostic.Kind implicitModelBindingSeverity;

    public ModelBindingValidator(Map<String, String> options) {
        this.missingModelObjectSeverity = Severity.of(options, MISSING_MODEL_OBJECT, Diagnostic.Kind.ERROR);
        this.missingModelAttributeSeverity = Severity.of(options, MISSING_MODEL_ATTRIBUTE, Diagnostic.Kind.ERROR);
        this.implicitModelBindingSeverity = Severity.of(options, IMPLICIT_MODEL_BINDING, Diagnostic.Kind.WARNING);
    }

    @Override
    public void validate(AptPmo pmo, Messager messager) {
        if (this.missingModelObjectSeverity != Diagnostic.Kind.OTHER) {
            pmo.getComponents().stream().map(AptComponent::getComponentDeclarations).flatMap(Collection::stream).filter(AptComponentDeclaration::isDirectModelBinding).filter(AptComponentDeclaration::isUsingStandardModelBindingAttributes).forEach(componentDeclaration -> {
                if (!componentDeclaration.getModelObject().isPresent()) {
                    this.reportMissingModelObject(messager, pmo, (AptComponentDeclaration)componentDeclaration);
                } else {
                    this.checkModelAttribute(messager, pmo, (AptComponentDeclaration)componentDeclaration, componentDeclaration.getModelObject().get());
                }
            });
        }
    }

    private void reportMissingModelObject(Messager messager, AptPmo pmo, AptComponentDeclaration componentDeclaration) {
        if (this.missingModelObjectSeverity != Diagnostic.Kind.OTHER && !SuppressedWarningsUtils.isSuppressed(pmo.getElement(), this.missingModelObjectSeverity) && !SuppressedWarningsUtils.isSuppressed(componentDeclaration.getElement(), this.missingModelObjectSeverity)) {
            AptAttribute modelObject = AptAttribute.findByName(componentDeclaration.getAttributes(), "modelObject").orElseThrow(() -> new IllegalStateException("expected \"modelObject\" to be present in annotation"));
            String modelObjectName = modelObject.getValue().toString();
            String message = Messages.format(MISSING_MODEL_OBJECT, componentDeclaration.getAnnotationMirror(), modelObjectName);
            messager.printMessage(this.missingModelObjectSeverity, message, componentDeclaration.getElement(), componentDeclaration.getAnnotationMirror(), modelObject.getAnnotationValue());
        }
    }

    private void checkModelAttribute(Messager messager, AptPmo pmo, AptComponentDeclaration componentDeclaration, AptModelObject modelObject) {
        AptAttribute modelAttribute = AptAttribute.findByName(componentDeclaration.getAttributes(), "modelAttribute").orElseThrow(() -> new IllegalStateException("expected \"modelAttribute\" to be present in annotation"));
        String modelAttributeName = modelAttribute.getValue().toString();
        if (this.isCreateReport(this.implicitModelBindingSeverity, pmo, componentDeclaration) && modelAttributeName.isEmpty()) {
            this.reportBadStyleMissingModelAttributeValue(messager, componentDeclaration);
        }
        if (this.isCreateReport(this.missingModelAttributeSeverity, pmo, componentDeclaration) && componentDeclaration.getModelAttribute().isEmpty()) {
            String attributeName = modelAttributeName.isEmpty() ? componentDeclaration.getPropertyName() : modelAttributeName;
            String invalidAttributeMessage = Messages.format(MISSING_MODEL_ATTRIBUTE, componentDeclaration.getAnnotationMirror(), modelObject.getAnnotation().name(), modelObject.getType().toString(), attributeName);
            messager.printMessage(this.missingModelAttributeSeverity, invalidAttributeMessage, componentDeclaration.getElement(), componentDeclaration.getAnnotationMirror(), modelAttribute.getAnnotationValue());
        }
    }

    private boolean isCreateReport(Diagnostic.Kind severity, AptPmo pmo, AptComponentDeclaration componentDeclaration) {
        return severity != Diagnostic.Kind.OTHER && !SuppressedWarningsUtils.isSuppressed(pmo.getElement(), severity) && !SuppressedWarningsUtils.isSuppressed(componentDeclaration.getElement(), severity);
    }

    private void reportBadStyleMissingModelAttributeValue(Messager messager, AptComponentDeclaration componentDeclaration) {
        String propertyName = componentDeclaration.getPropertyName();
        String message = Messages.format(IMPLICIT_MODEL_BINDING, componentDeclaration.getAnnotationMirror(), propertyName, propertyName);
        messager.printMessage(this.implicitModelBindingSeverity, message, componentDeclaration.getElement(), componentDeclaration.getAnnotationMirror());
    }
}

