/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.tooling.apt.validator;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import org.linkki.tooling.apt.model.AptModelObject;
import org.linkki.tooling.apt.model.AptPmo;
import org.linkki.tooling.apt.util.Either;
import org.linkki.tooling.apt.util.SuppressedWarningsUtils;
import org.linkki.tooling.apt.validator.MessageCodes;
import org.linkki.tooling.apt.validator.Messages;
import org.linkki.tooling.apt.validator.Severity;
import org.linkki.tooling.apt.validator.Validator;

@MessageCodes(value={"MODEL_OBJECT_CLASH"})
public class ModelObjectValidator
implements Validator {
    public static final String MODEL_OBJECT_CLASH = "MODEL_OBJECT_CLASH";
    private final Diagnostic.Kind modelObjectClashSeverity;

    public ModelObjectValidator(Map<String, String> options) {
        this.modelObjectClashSeverity = Severity.of(options, MODEL_OBJECT_CLASH, Diagnostic.Kind.ERROR);
    }

    @Override
    public void validate(AptPmo pmo, Messager messager) {
        if (this.modelObjectClashSeverity == Diagnostic.Kind.OTHER || SuppressedWarningsUtils.isSuppressed(pmo.getElement(), this.modelObjectClashSeverity)) {
            return;
        }
        pmo.getModelObjects().stream().collect(Collectors.groupingBy(it -> it.getAnnotation().name())).values().stream().filter(it -> it.size() > 1).forEach(collidingModelObjects -> this.print(messager, (List<AptModelObject>)collidingModelObjects));
    }

    private void print(Messager messager, List<AptModelObject> collidingModelObjects) {
        collidingModelObjects.stream().filter(it -> !this.isSuppressed(it.getElement(), this.modelObjectClashSeverity)).forEach(current -> {
            Element member = current.getMember();
            AnnotationMirror currentAnnotationMirror = current.getAnnotationMirror();
            String name = current.getAnnotation().name();
            String modelObjetNameValuePair = this.getModelObjetNameValuePair(name);
            Optional<? extends AnnotationValue> annotationValue = currentAnnotationMirror.getElementValues().values().stream().findFirst();
            collidingModelObjects.stream().filter(o -> o != current).forEach(otherModelObject -> {
                String otherMember = otherModelObject.getMember().getSimpleName().toString();
                String message = Messages.format(MODEL_OBJECT_CLASH, currentAnnotationMirror, modelObjetNameValuePair, otherMember);
                annotationValue.ifPresentOrElse(it -> messager.printMessage(this.modelObjectClashSeverity, message, member, currentAnnotationMirror, (AnnotationValue)it), () -> messager.printMessage(this.modelObjectClashSeverity, message, member, currentAnnotationMirror));
            });
        });
    }

    private boolean isSuppressed(Either<? extends VariableElement, ? extends ExecutableElement> element, Diagnostic.Kind kind) {
        return SuppressedWarningsUtils.isSuppressed((Element)Either.get(element));
    }

    private String getModelObjetNameValuePair(String name) {
        return "name " + '\"' + name + '\"';
    }
}

