/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.ExplainVerbosity;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.client.model.Collation;
import com.mongodb.internal.TimeoutSettings;
import com.mongodb.internal.operation.Operations;
import com.mongodb.internal.operation.ReadOperationExplainable;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.ListSearchIndexesPublisher;
import com.mongodb.reactivestreams.client.internal.BatchCursorPublisher;
import com.mongodb.reactivestreams.client.internal.MongoOperationPublisher;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.Decoder;
import org.reactivestreams.Publisher;

final class ListSearchIndexesPublisherImpl<T>
extends BatchCursorPublisher<T>
implements ListSearchIndexesPublisher<T> {
    @Nullable
    private Boolean allowDiskUse;
    private long maxTimeMS;
    @Nullable
    private Collation collation;
    @Nullable
    private BsonValue comment;
    @Nullable
    private String indexName;

    ListSearchIndexesPublisherImpl(MongoOperationPublisher<T> mongoOperationPublisher) {
        super(null, mongoOperationPublisher);
    }

    @Override
    public ListSearchIndexesPublisher<T> name(String indexName) {
        this.indexName = (String)Assertions.notNull((String)"indexName", (Object)indexName);
        return this;
    }

    @Override
    public ListSearchIndexesPublisher<T> allowDiskUse(@Nullable Boolean allowDiskUse) {
        this.allowDiskUse = allowDiskUse;
        return this;
    }

    @Override
    public ListSearchIndexesPublisher<T> batchSize(int batchSize) {
        super.batchSize(batchSize);
        return this;
    }

    @Override
    public ListSearchIndexesPublisher<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public ListSearchIndexesPublisher<T> collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public ListSearchIndexesPublisher<T> comment(@Nullable String comment) {
        this.comment = comment != null ? new BsonString(comment) : null;
        return this;
    }

    @Override
    public ListSearchIndexesPublisher<T> timeoutMode(TimeoutMode timeoutMode) {
        super.timeoutMode(timeoutMode);
        return this;
    }

    @Override
    public ListSearchIndexesPublisher<T> comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public Publisher<Document> explain() {
        return this.publishExplain(Document.class, null);
    }

    @Override
    public Publisher<Document> explain(ExplainVerbosity verbosity) {
        Assertions.notNull((String)"verbosity", (Object)verbosity);
        return this.publishExplain(Document.class, verbosity);
    }

    @Override
    public <E> Publisher<E> explain(Class<E> explainResultClass) {
        Assertions.notNull((String)"explainResultClass", explainResultClass);
        return this.publishExplain(explainResultClass, null);
    }

    @Override
    public <E> Publisher<E> explain(Class<E> explainResultClass, ExplainVerbosity verbosity) {
        Assertions.notNull((String)"verbosity", (Object)verbosity);
        Assertions.notNull((String)"explainResultClass", explainResultClass);
        return this.publishExplain(explainResultClass, verbosity);
    }

    private <E> Publisher<E> publishExplain(Class<E> explainResultClass, @Nullable ExplainVerbosity verbosity) {
        return this.getMongoOperationPublisher().createReadOperationMono(operations -> operations.createTimeoutSettings(this.maxTimeMS), () -> this.asReadOperation(1).asExplainableOperation(verbosity, (Decoder)this.getCodecRegistry().get(explainResultClass)), this.getClientSession());
    }

    @Override
    ReadOperationExplainable<T> asReadOperation(int initialBatchSize) {
        return this.getOperations().listSearchIndexes(this.getDocumentClass(), this.indexName, Integer.valueOf(initialBatchSize), this.collation, this.comment, this.allowDiskUse);
    }

    @Override
    Function<Operations<?>, TimeoutSettings> getTimeoutSettings() {
        return operations -> operations.createTimeoutSettings(this.maxTimeMS);
    }
}

