/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.server.web.StaticContentFilter;

class StaticContentFilterTest {
    StaticContentFilterTest() {
    }

    @Test
    void shouldAddStaticContentHeadersToHtmlResponses() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getServletPath()).thenReturn((Object)"index.html");
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain filterChain = (FilterChain)Mockito.mock(FilterChain.class);
        new StaticContentFilter().doFilter((ServletRequest)request, (ServletResponse)response, filterChain);
        ((HttpServletResponse)Mockito.verify((Object)response)).addHeader("Cache-Control", "private, no-cache, no-store, proxy-revalidate, no-transform");
        ((HttpServletResponse)Mockito.verify((Object)response)).addHeader("Pragma", "no-cache");
        ((HttpServletResponse)Mockito.verify((Object)response)).addHeader("Content-Security-Policy", "frame-ancestors 'none'");
        ((HttpServletResponse)Mockito.verify((Object)response)).addHeader("X-Frame-Options", "DENY");
        ((HttpServletResponse)Mockito.verify((Object)response)).addHeader("X-Content-Type-Options", "nosniff");
        ((HttpServletResponse)Mockito.verify((Object)response)).addHeader("X-XSS-Protection", "1; mode=block");
        ((FilterChain)Mockito.verify((Object)filterChain)).doFilter((ServletRequest)request, (ServletResponse)response);
    }

    @Test
    void shouldPassThroughRequestsForNonHtmlResources() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getServletPath()).thenReturn((Object)"index.js");
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain filterChain = (FilterChain)Mockito.mock(FilterChain.class);
        new StaticContentFilter().doFilter((ServletRequest)request, (ServletResponse)response, filterChain);
        Mockito.verifyNoInteractions((Object[])new Object[]{response});
        ((FilterChain)Mockito.verify((Object)filterChain)).doFilter((ServletRequest)request, (ServletResponse)response);
    }

    @Test
    void shouldPassThroughRequestsWithNullServletPath() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getServletPath()).thenReturn(null);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain filterChain = (FilterChain)Mockito.mock(FilterChain.class);
        new StaticContentFilter().doFilter((ServletRequest)request, (ServletResponse)response, filterChain);
        Mockito.verifyNoInteractions((Object[])new Object[]{response});
        ((FilterChain)Mockito.verify((Object)filterChain)).doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

