/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup;

import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import java.time.Clock;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.neo4j.causalclustering.catchup.CatchUpClient;
import org.neo4j.causalclustering.catchup.CatchUpResponseHandler;
import org.neo4j.causalclustering.catchup.CatchupProtocolClientInstaller;
import org.neo4j.causalclustering.handlers.VoidPipelineWrapperFactory;
import org.neo4j.causalclustering.protocol.ModifierProtocolInstaller;
import org.neo4j.causalclustering.protocol.NettyPipelineBuilderFactory;
import org.neo4j.causalclustering.protocol.Protocol;
import org.neo4j.causalclustering.protocol.ProtocolInstaller;
import org.neo4j.causalclustering.protocol.ProtocolInstallerRepository;
import org.neo4j.causalclustering.protocol.handshake.ApplicationProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.ApplicationSupportedProtocols;
import org.neo4j.causalclustering.protocol.handshake.HandshakeClientInitializer;
import org.neo4j.causalclustering.protocol.handshake.ModifierProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.ModifierSupportedProtocols;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.time.Clocks;

public class CatchupClientBuilder {
    private Duration handshakeTimeout = Duration.ofSeconds(5L);
    private LogProvider debugLogProvider = NullLogProvider.getInstance();
    private LogProvider userLogProvider = NullLogProvider.getInstance();
    private NettyPipelineBuilderFactory pipelineBuilder = new NettyPipelineBuilderFactory(VoidPipelineWrapperFactory.VOID_WRAPPER);
    private ApplicationSupportedProtocols catchupProtocols = new ApplicationSupportedProtocols(Protocol.ApplicationProtocolCategory.CATCHUP, Collections.emptyList());
    private Collection<ModifierSupportedProtocols> modifierProtocols = Collections.emptyList();
    private Clock clock = Clocks.systemClock();
    private long inactivityTimeoutMillis = TimeUnit.SECONDS.toMillis(10L);

    public CatchupClientBuilder() {
    }

    public CatchupClientBuilder(ApplicationSupportedProtocols catchupProtocols, Collection<ModifierSupportedProtocols> modifierProtocols, NettyPipelineBuilderFactory pipelineBuilder, Duration handshakeTimeout, LogProvider debugLogProvider, LogProvider userLogProvider, Clock clock) {
        this.catchupProtocols = catchupProtocols;
        this.modifierProtocols = modifierProtocols;
        this.pipelineBuilder = pipelineBuilder;
        this.handshakeTimeout = handshakeTimeout;
        this.debugLogProvider = debugLogProvider;
        this.userLogProvider = userLogProvider;
        this.clock = clock;
    }

    public CatchupClientBuilder catchupProtocols(ApplicationSupportedProtocols catchupProtocols) {
        this.catchupProtocols = catchupProtocols;
        return this;
    }

    public CatchupClientBuilder modifierProtocols(Collection<ModifierSupportedProtocols> modifierProtocols) {
        this.modifierProtocols = modifierProtocols;
        return this;
    }

    public CatchupClientBuilder pipelineBuilder(NettyPipelineBuilderFactory pipelineBuilder) {
        this.pipelineBuilder = pipelineBuilder;
        return this;
    }

    public CatchupClientBuilder handshakeTimeout(Duration handshakeTimeout) {
        this.handshakeTimeout = handshakeTimeout;
        return this;
    }

    public CatchupClientBuilder inactivityTimeoutMillis(long inactivityTimeoutMillis) {
        this.inactivityTimeoutMillis = inactivityTimeoutMillis;
        return this;
    }

    public CatchupClientBuilder debugLogProvider(LogProvider debugLogProvider) {
        this.debugLogProvider = debugLogProvider;
        return this;
    }

    public CatchupClientBuilder userLogProvider(LogProvider userLogProvider) {
        this.userLogProvider = userLogProvider;
        return this;
    }

    public CatchupClientBuilder clock(Clock clock) {
        this.clock = clock;
        return this;
    }

    public CatchUpClient build() {
        ApplicationProtocolRepository applicationProtocolRepository = new ApplicationProtocolRepository(Protocol.ApplicationProtocols.values(), this.catchupProtocols);
        ModifierProtocolRepository modifierProtocolRepository = new ModifierProtocolRepository(Protocol.ModifierProtocols.values(), this.modifierProtocols);
        Function<CatchUpResponseHandler, ChannelInitializer<SocketChannel>> channelInitializer = handler -> {
            List installers = Collections.singletonList(new CatchupProtocolClientInstaller.Factory(this.pipelineBuilder, this.debugLogProvider, (CatchUpResponseHandler)handler));
            ProtocolInstallerRepository<ProtocolInstaller.Orientation.Client> protocolInstallerRepository = new ProtocolInstallerRepository<ProtocolInstaller.Orientation.Client>(installers, ModifierProtocolInstaller.allClientInstallers);
            return new HandshakeClientInitializer(applicationProtocolRepository, modifierProtocolRepository, protocolInstallerRepository, this.pipelineBuilder, this.handshakeTimeout, this.debugLogProvider, this.userLogProvider);
        };
        return new CatchUpClient(this.debugLogProvider, this.clock, this.inactivityTimeoutMillis, channelInitializer);
    }
}

