/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup;

import org.neo4j.causalclustering.catchup.CatchupAddressResolutionException;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.upstream.UpstreamDatabaseSelectionException;
import org.neo4j.causalclustering.upstream.UpstreamDatabaseStrategySelector;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.helpers.AdvertisedSocketAddress;

public class UpstreamStrategyAddressSupplier
implements ThrowingSupplier<AdvertisedSocketAddress, CatchupAddressResolutionException> {
    private final UpstreamDatabaseStrategySelector strategySelector;
    private final TopologyService topologyService;

    UpstreamStrategyAddressSupplier(UpstreamDatabaseStrategySelector strategySelector, TopologyService topologyService) {
        this.strategySelector = strategySelector;
        this.topologyService = topologyService;
    }

    public AdvertisedSocketAddress get() throws CatchupAddressResolutionException {
        try {
            MemberId upstreamMember = this.strategySelector.bestUpstreamDatabase();
            return this.topologyService.findCatchupAddress(upstreamMember).orElseThrow(() -> new CatchupAddressResolutionException(upstreamMember));
        }
        catch (UpstreamDatabaseSelectionException e) {
            throw new CatchupAddressResolutionException(e);
        }
    }
}

