/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.function.Supplier;
import org.neo4j.causalclustering.catchup.storecopy.StoreFiles;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.availability.AvailabilityRequirement;
import org.neo4j.kernel.availability.DescriptiveAvailabilityRequirement;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionRepresentationCommitProcess;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.StorageEngine;

public class LocalDatabase
implements Lifecycle {
    private static final AvailabilityRequirement NOT_STOPPED = new DescriptiveAvailabilityRequirement("Database is stopped");
    private static final AvailabilityRequirement NOT_COPYING_STORE = new DescriptiveAvailabilityRequirement("Database is stopped to copy store from another cluster member");
    private final DatabaseLayout databaseLayout;
    private final StoreFiles storeFiles;
    private final DataSourceManager dataSourceManager;
    private final Supplier<DatabaseHealth> databaseHealthSupplier;
    private final AvailabilityGuard availabilityGuard;
    private final Log log;
    private volatile StoreId storeId;
    private volatile DatabaseHealth databaseHealth;
    private volatile AvailabilityRequirement currentRequirement;
    private volatile TransactionCommitProcess localCommit;
    private final LogFiles logFiles;

    public LocalDatabase(DatabaseLayout databaseLayout, StoreFiles storeFiles, LogFiles logFiles, DataSourceManager dataSourceManager, Supplier<DatabaseHealth> databaseHealthSupplier, AvailabilityGuard availabilityGuard, LogProvider logProvider) {
        this.databaseLayout = databaseLayout;
        this.storeFiles = storeFiles;
        this.logFiles = logFiles;
        this.dataSourceManager = dataSourceManager;
        this.databaseHealthSupplier = databaseHealthSupplier;
        this.availabilityGuard = availabilityGuard;
        this.log = logProvider.getLog(this.getClass());
        this.raiseAvailabilityGuard(NOT_STOPPED);
    }

    public void init() {
        this.dataSourceManager.init();
    }

    public synchronized void start() {
        if (this.isAvailable()) {
            return;
        }
        this.storeId = this.readStoreIdFromDisk();
        this.log.info("Starting with storeId: " + this.storeId);
        this.dataSourceManager.start();
        this.dropAvailabilityGuard();
    }

    public void stop() throws Throwable {
        this.stopWithRequirement(NOT_STOPPED);
    }

    public void stopForStoreCopy() throws Throwable {
        this.stopWithRequirement(NOT_COPYING_STORE);
    }

    public boolean isAvailable() {
        return this.currentRequirement == null;
    }

    public void shutdown() {
        this.dataSourceManager.shutdown();
    }

    public synchronized StoreId storeId() {
        if (this.isAvailable()) {
            return this.storeId;
        }
        return this.readStoreIdFromDisk();
    }

    private StoreId readStoreIdFromDisk() {
        try {
            return this.storeFiles.readStoreId(this.databaseLayout);
        }
        catch (IOException e) {
            this.log.error("Failure reading store id", (Throwable)e);
            return null;
        }
    }

    public void panic(Throwable cause) {
        this.getDatabaseHealth().panic(cause);
    }

    public <EXCEPTION extends Throwable> void assertHealthy(Class<EXCEPTION> cause) throws EXCEPTION {
        this.getDatabaseHealth().assertHealthy(cause);
    }

    private DatabaseHealth getDatabaseHealth() {
        if (this.databaseHealth == null) {
            this.databaseHealth = this.databaseHealthSupplier.get();
        }
        return this.databaseHealth;
    }

    public void delete() throws IOException {
        this.storeFiles.delete(this.databaseLayout.databaseDirectory(), this.logFiles);
    }

    public boolean isEmpty() throws IOException {
        Set filesToLookFor = this.databaseLayout.storeFiles();
        return this.storeFiles.isEmpty(this.databaseLayout.databaseDirectory(), filesToLookFor);
    }

    public DatabaseLayout databaseLayout() {
        return this.databaseLayout;
    }

    void replaceWith(File sourceDir) throws IOException {
        this.storeFiles.delete(this.databaseLayout.databaseDirectory(), this.logFiles);
        this.storeFiles.moveTo(sourceDir, this.databaseLayout.databaseDirectory(), this.logFiles);
    }

    public NeoStoreDataSource dataSource() {
        return this.dataSourceManager.getDataSource();
    }

    public void registerCommitProcessDependencies(TransactionAppender appender, StorageEngine applier) {
        this.localCommit = new TransactionRepresentationCommitProcess(appender, applier);
    }

    public TransactionCommitProcess getCommitProcess() {
        return this.localCommit;
    }

    private synchronized void stopWithRequirement(AvailabilityRequirement requirement) throws Throwable {
        this.log.info("Stopping, reason: " + requirement.description());
        this.raiseAvailabilityGuard(requirement);
        this.databaseHealth = null;
        this.localCommit = null;
        this.dataSourceManager.stop();
    }

    private void raiseAvailabilityGuard(AvailabilityRequirement requirement) {
        this.availabilityGuard.require(requirement);
        if (this.currentRequirement != null) {
            this.dropAvailabilityGuard();
        }
        this.currentRequirement = requirement;
    }

    private void dropAvailabilityGuard() {
        this.availabilityGuard.fulfill(this.currentRequirement);
        this.currentRequirement = null;
    }
}

