/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.time.Clock;
import java.util.concurrent.TimeUnit;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFailedException;
import org.neo4j.causalclustering.catchup.storecopy.TerminationCondition;
import org.neo4j.time.Clocks;

public class MaximumTotalTime
implements TerminationCondition {
    private final long endTime;
    private final Clock clock;
    private long time;
    private TimeUnit timeUnit;

    public MaximumTotalTime(long time, TimeUnit timeUnit) {
        this(time, timeUnit, Clocks.systemClock());
    }

    MaximumTotalTime(long time, TimeUnit timeUnit, Clock clock) {
        this.endTime = clock.millis() + timeUnit.toMillis(time);
        this.clock = clock;
        this.time = time;
        this.timeUnit = timeUnit;
    }

    @Override
    public void assertContinue() throws StoreCopyFailedException {
        if (this.clock.millis() > this.endTime) {
            throw new StoreCopyFailedException(String.format("Maximum time passed %d %s. Not allowed to continue", new Object[]{this.time, this.timeUnit}));
        }
    }
}

