/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.File;
import java.io.IOException;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.neo4j.causalclustering.catchup.storecopy.CloseablesListener;
import org.neo4j.causalclustering.catchup.storecopy.StoreResource;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.storageengine.api.StoreFileMetadata;

public class PrepareStoreCopyFiles
implements AutoCloseable {
    private final NeoStoreDataSource neoStoreDataSource;
    private final FileSystemAbstraction fileSystemAbstraction;
    private final CloseablesListener closeablesListener = new CloseablesListener();

    PrepareStoreCopyFiles(NeoStoreDataSource neoStoreDataSource, FileSystemAbstraction fileSystemAbstraction) {
        this.neoStoreDataSource = neoStoreDataSource;
        this.fileSystemAbstraction = fileSystemAbstraction;
    }

    LongSet getNonAtomicIndexIds() {
        return LongSets.immutable.empty();
    }

    StoreResource[] getAtomicFilesSnapshot() throws IOException {
        ResourceIterator neoStoreFilesIterator = this.closeablesListener.add(this.neoStoreDataSource.getNeoStoreFileListing().builder().excludeAll().includeNeoStoreFiles().build());
        ResourceIterator indexIterator = this.closeablesListener.add(this.neoStoreDataSource.getNeoStoreFileListing().builder().excludeAll().includeExplicitIndexStoreStoreFiles().includeAdditionalProviders().includeLabelScanStoreFiles().includeSchemaIndexStoreFiles().build());
        return (StoreResource[])Stream.concat(neoStoreFilesIterator.stream().filter(PrepareStoreCopyFiles.isCountFile(this.neoStoreDataSource.getDatabaseLayout())), indexIterator.stream()).map(this.mapToStoreResource()).toArray(StoreResource[]::new);
    }

    private Function<StoreFileMetadata, StoreResource> mapToStoreResource() {
        return storeFileMetadata -> {
            try {
                return this.toStoreResource((StoreFileMetadata)storeFileMetadata);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to create store resource", e);
            }
        };
    }

    File[] listReplayableFiles() throws IOException {
        try (Stream stream = this.neoStoreDataSource.getNeoStoreFileListing().builder().excludeLogFiles().excludeExplicitIndexStoreFiles().excludeSchemaIndexStoreFiles().excludeAdditionalProviders().build().stream();){
            File[] fileArray = (File[])stream.filter(PrepareStoreCopyFiles.isCountFile(this.neoStoreDataSource.getDatabaseLayout()).negate()).map(StoreFileMetadata::file).toArray(File[]::new);
            return fileArray;
        }
    }

    private static Predicate<StoreFileMetadata> isCountFile(DatabaseLayout databaseLayout) {
        return storeFileMetadata -> databaseLayout.countStoreB().equals(storeFileMetadata.file()) || databaseLayout.countStoreA().equals(storeFileMetadata.file());
    }

    private StoreResource toStoreResource(StoreFileMetadata storeFileMetadata) throws IOException {
        File databaseDirectory = this.neoStoreDataSource.getDatabaseLayout().databaseDirectory();
        File file = storeFileMetadata.file();
        String relativePath = FileUtils.relativePath((File)databaseDirectory, (File)file);
        return new StoreResource(file, relativePath, storeFileMetadata.recordSize(), this.fileSystemAbstraction);
    }

    @Override
    public void close() {
        this.closeablesListener.close();
    }
}

