/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.File;
import java.net.ConnectException;
import java.nio.file.Paths;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.eclipse.collections.api.iterator.LongIterator;
import org.neo4j.causalclustering.catchup.CatchUpClient;
import org.neo4j.causalclustering.catchup.CatchUpClientException;
import org.neo4j.causalclustering.catchup.CatchUpResponseAdaptor;
import org.neo4j.causalclustering.catchup.CatchupAddressProvider;
import org.neo4j.causalclustering.catchup.CatchupAddressResolutionException;
import org.neo4j.causalclustering.catchup.storecopy.GetIndexFilesRequest;
import org.neo4j.causalclustering.catchup.storecopy.GetStoreFileRequest;
import org.neo4j.causalclustering.catchup.storecopy.GetStoreIdRequest;
import org.neo4j.causalclustering.catchup.storecopy.GetStoreIdResponse;
import org.neo4j.causalclustering.catchup.storecopy.PrepareStoreCopyRequest;
import org.neo4j.causalclustering.catchup.storecopy.PrepareStoreCopyResponse;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFailedException;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFinishedResponse;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyResponseAdaptors;
import org.neo4j.causalclustering.catchup.storecopy.StoreFileStreamProvider;
import org.neo4j.causalclustering.catchup.storecopy.StoreIdDownloadFailedException;
import org.neo4j.causalclustering.catchup.storecopy.TerminationCondition;
import org.neo4j.causalclustering.helper.TimeoutStrategy;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.causalclustering.messaging.CatchUpRequest;
import org.neo4j.com.storecopy.StoreCopyClientMonitor;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class StoreCopyClient {
    private final CatchUpClient catchUpClient;
    private final Log log;
    private TimeoutStrategy backOffStrategy;
    private final Monitors monitors;

    public StoreCopyClient(CatchUpClient catchUpClient, Monitors monitors, LogProvider logProvider, TimeoutStrategy backOffStrategy) {
        this.catchUpClient = catchUpClient;
        this.monitors = monitors;
        this.log = logProvider.getLog(this.getClass());
        this.backOffStrategy = backOffStrategy;
    }

    long copyStoreFiles(CatchupAddressProvider catchupAddressProvider, StoreId expectedStoreId, StoreFileStreamProvider storeFileStreamProvider, Supplier<TerminationCondition> requestWiseTerminationCondition, File destDir) throws StoreCopyFailedException {
        try {
            PrepareStoreCopyResponse prepareStoreCopyResponse = this.prepareStoreCopy(catchupAddressProvider.primary(), expectedStoreId, storeFileStreamProvider);
            this.copyFilesIndividually(prepareStoreCopyResponse, expectedStoreId, catchupAddressProvider, storeFileStreamProvider, requestWiseTerminationCondition, destDir);
            this.copyIndexSnapshotIndividually(prepareStoreCopyResponse, expectedStoreId, catchupAddressProvider, storeFileStreamProvider, requestWiseTerminationCondition);
            return prepareStoreCopyResponse.lastTransactionId();
        }
        catch (CatchUpClientException | CatchupAddressResolutionException e) {
            throw new StoreCopyFailedException(e);
        }
    }

    private void copyFilesIndividually(PrepareStoreCopyResponse prepareStoreCopyResponse, StoreId expectedStoreId, CatchupAddressProvider addressProvider, StoreFileStreamProvider storeFileStream, Supplier<TerminationCondition> terminationConditions, File destDir) throws StoreCopyFailedException {
        StoreCopyClientMonitor storeCopyClientMonitor = (StoreCopyClientMonitor)this.monitors.newMonitor(StoreCopyClientMonitor.class, new String[0]);
        storeCopyClientMonitor.startReceivingStoreFiles();
        long lastTransactionId = prepareStoreCopyResponse.lastTransactionId();
        for (File file : prepareStoreCopyResponse.getFiles()) {
            storeCopyClientMonitor.startReceivingStoreFile(Paths.get(destDir.toString(), file.getName()).toString());
            this.persistentCallToSecondary(new GetStoreFileRequest(expectedStoreId, file, lastTransactionId), StoreCopyResponseAdaptors.filesCopyAdaptor(storeFileStream, this.log), addressProvider, terminationConditions.get());
            storeCopyClientMonitor.finishReceivingStoreFile(Paths.get(destDir.toString(), file.getName()).toString());
        }
        storeCopyClientMonitor.finishReceivingStoreFiles();
    }

    private void copyIndexSnapshotIndividually(PrepareStoreCopyResponse prepareStoreCopyResponse, StoreId expectedStoreId, CatchupAddressProvider addressProvider, StoreFileStreamProvider storeFileStream, Supplier<TerminationCondition> terminationConditions) throws StoreCopyFailedException {
        StoreCopyClientMonitor storeCopyClientMonitor = (StoreCopyClientMonitor)this.monitors.newMonitor(StoreCopyClientMonitor.class, new String[0]);
        long lastTransactionId = prepareStoreCopyResponse.lastTransactionId();
        LongIterator indexIds = prepareStoreCopyResponse.getIndexIds().longIterator();
        storeCopyClientMonitor.startReceivingIndexSnapshots();
        while (indexIds.hasNext()) {
            long indexId = indexIds.next();
            storeCopyClientMonitor.startReceivingIndexSnapshot(indexId);
            this.persistentCallToSecondary(new GetIndexFilesRequest(expectedStoreId, indexId, lastTransactionId), StoreCopyResponseAdaptors.filesCopyAdaptor(storeFileStream, this.log), addressProvider, terminationConditions.get());
            storeCopyClientMonitor.finishReceivingIndexSnapshot(indexId);
        }
        storeCopyClientMonitor.finishReceivingIndexSnapshots();
    }

    private void persistentCallToSecondary(CatchUpRequest request, CatchUpResponseAdaptor<StoreCopyFinishedResponse> copyHandler, CatchupAddressProvider addressProvider, TerminationCondition terminationCondition) throws StoreCopyFailedException {
        TimeoutStrategy.Timeout timeout = this.backOffStrategy.newTimeout();
        while (true) {
            try {
                AdvertisedSocketAddress address = addressProvider.secondary();
                this.log.info(String.format("Sending request '%s' to '%s'", request, address));
                StoreCopyFinishedResponse response = this.catchUpClient.makeBlockingRequest(address, request, copyHandler);
                if (this.successfulRequest(response, request)) {
                    break;
                }
            }
            catch (CatchUpClientException e) {
                Throwable cause = e.getCause();
                if (cause instanceof ConnectException) {
                    this.log.warn(cause.getMessage());
                } else {
                    this.log.warn(String.format("Request failed exceptionally '%s'.", request), (Throwable)e);
                }
            }
            catch (CatchupAddressResolutionException e) {
                this.log.warn("Unable to resolve address for '%s'. %s", new Object[]{request, e.getMessage()});
            }
            terminationCondition.assertContinue();
            this.awaitAndIncrementTimeout(timeout);
        }
    }

    private void awaitAndIncrementTimeout(TimeoutStrategy.Timeout timeout) throws StoreCopyFailedException {
        try {
            Thread.sleep(timeout.getMillis());
            timeout.increment();
        }
        catch (InterruptedException e) {
            throw new StoreCopyFailedException("Thread interrupted");
        }
    }

    private PrepareStoreCopyResponse prepareStoreCopy(AdvertisedSocketAddress from, StoreId expectedStoreId, StoreFileStreamProvider storeFileStream) throws CatchUpClientException, StoreCopyFailedException {
        this.log.info("Requesting store listing from: " + from);
        PrepareStoreCopyResponse prepareStoreCopyResponse = this.catchUpClient.makeBlockingRequest(from, new PrepareStoreCopyRequest(expectedStoreId), StoreCopyResponseAdaptors.prepareStoreCopyAdaptor(storeFileStream, this.log));
        if (prepareStoreCopyResponse.status() != PrepareStoreCopyResponse.Status.SUCCESS) {
            throw new StoreCopyFailedException("Preparing store failed due to: " + (Object)((Object)prepareStoreCopyResponse.status()));
        }
        return prepareStoreCopyResponse;
    }

    public StoreId fetchStoreId(AdvertisedSocketAddress fromAddress) throws StoreIdDownloadFailedException {
        try {
            CatchUpResponseAdaptor<StoreId> responseHandler = new CatchUpResponseAdaptor<StoreId>(){

                @Override
                public void onGetStoreIdResponse(CompletableFuture<StoreId> signal, GetStoreIdResponse response) {
                    signal.complete(response.storeId());
                }
            };
            return this.catchUpClient.makeBlockingRequest(fromAddress, new GetStoreIdRequest(), responseHandler);
        }
        catch (CatchUpClientException e) {
            throw new StoreIdDownloadFailedException(e);
        }
    }

    private boolean successfulRequest(StoreCopyFinishedResponse response, CatchUpRequest request) throws StoreCopyFailedException {
        StoreCopyFinishedResponse.Status responseStatus = response.status();
        if (responseStatus == StoreCopyFinishedResponse.Status.SUCCESS) {
            this.log.info(String.format("Request was successful '%s'", request));
            return true;
        }
        if (StoreCopyFinishedResponse.Status.E_TOO_FAR_BEHIND == responseStatus || StoreCopyFinishedResponse.Status.E_UNKNOWN == responseStatus || StoreCopyFinishedResponse.Status.E_STORE_ID_MISMATCH == responseStatus) {
            this.log.warn(String.format("Request failed '%s'. With response: %s", new Object[]{request, response.status()}));
            return false;
        }
        throw new StoreCopyFailedException(String.format("Request responded with an unknown response type: %s. '%s'", new Object[]{responseStatus, request}));
    }
}

