/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.catchup.CatchupServerProtocol;
import org.neo4j.causalclustering.catchup.CheckPointerService;
import org.neo4j.causalclustering.catchup.storecopy.DataSourceChecks;
import org.neo4j.causalclustering.catchup.storecopy.GetIndexFilesRequest;
import org.neo4j.causalclustering.catchup.storecopy.GetStoreFileRequest;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFinishedResponse;
import org.neo4j.causalclustering.catchup.storecopy.StoreFileStreamingProtocol;
import org.neo4j.causalclustering.catchup.storecopy.StoreResource;
import org.neo4j.causalclustering.messaging.StoreCopyRequest;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.StoreFileMetadata;

public abstract class StoreCopyRequestHandler<T extends StoreCopyRequest>
extends SimpleChannelInboundHandler<T> {
    private final CatchupServerProtocol protocol;
    private final Supplier<NeoStoreDataSource> dataSource;
    private final CheckPointerService checkPointerService;
    private final StoreFileStreamingProtocol storeFileStreamingProtocol;
    private final FileSystemAbstraction fs;
    private final Log log;

    StoreCopyRequestHandler(CatchupServerProtocol protocol, Supplier<NeoStoreDataSource> dataSource, CheckPointerService checkPointerService, StoreFileStreamingProtocol storeFileStreamingProtocol, FileSystemAbstraction fs, LogProvider logProvider) {
        this.protocol = protocol;
        this.dataSource = dataSource;
        this.storeFileStreamingProtocol = storeFileStreamingProtocol;
        this.fs = fs;
        this.log = logProvider.getLog(StoreCopyRequestHandler.class);
        this.checkPointerService = checkPointerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, T request) throws Exception {
        block18: {
            this.log.debug("Handling request %s", new Object[]{request});
            StoreCopyFinishedResponse.Status responseStatus = StoreCopyFinishedResponse.Status.E_UNKNOWN;
            try {
                NeoStoreDataSource neoStoreDataSource = this.dataSource.get();
                if (!DataSourceChecks.hasSameStoreId(request.expectedStoreId(), neoStoreDataSource)) {
                    responseStatus = StoreCopyFinishedResponse.Status.E_STORE_ID_MISMATCH;
                    break block18;
                }
                if (!DataSourceChecks.isTransactionWithinReach(request.requiredTransactionId(), this.checkPointerService)) {
                    responseStatus = StoreCopyFinishedResponse.Status.E_TOO_FAR_BEHIND;
                    this.checkPointerService.tryAsyncCheckpoint(e -> this.log.error("Failed to do a checkpoint that was invoked after a too far behind error on store copy request", (Throwable)e));
                    break block18;
                }
                File databaseDirectory = neoStoreDataSource.getDatabaseLayout().databaseDirectory();
                try (ResourceIterator<StoreFileMetadata> resourceIterator = this.files(request, neoStoreDataSource);){
                    while (resourceIterator.hasNext()) {
                        StoreFileMetadata storeFileMetadata = (StoreFileMetadata)resourceIterator.next();
                        StoreResource storeResource = new StoreResource(storeFileMetadata.file(), FileUtils.relativePath((File)databaseDirectory, (File)storeFileMetadata.file()), storeFileMetadata.recordSize(), this.fs);
                        this.storeFileStreamingProtocol.stream(ctx, storeResource);
                    }
                }
                responseStatus = StoreCopyFinishedResponse.Status.SUCCESS;
            }
            finally {
                this.storeFileStreamingProtocol.end(ctx, responseStatus);
                this.protocol.expect(CatchupServerProtocol.State.MESSAGE_TYPE);
            }
        }
    }

    abstract ResourceIterator<StoreFileMetadata> files(T var1, NeoStoreDataSource var2) throws IOException;

    private static Iterator<StoreFileMetadata> onlyOne(List<StoreFileMetadata> files, String description) {
        if (files.size() != 1) {
            throw new IllegalStateException(String.format("Expected exactly one file '%s'. Got %d", description, files.size()));
        }
        return files.iterator();
    }

    private static Predicate<StoreFileMetadata> matchesRequested(String fileName) {
        return f -> f.file().getName().equals(fileName);
    }

    public static class GetIndexSnapshotRequestHandler
    extends StoreCopyRequestHandler<GetIndexFilesRequest> {
        public GetIndexSnapshotRequestHandler(CatchupServerProtocol protocol, Supplier<NeoStoreDataSource> dataSource, CheckPointerService checkPointerService, StoreFileStreamingProtocol storeFileStreamingProtocol, FileSystemAbstraction fs, LogProvider logProvider) {
            super(protocol, dataSource, checkPointerService, storeFileStreamingProtocol, fs, logProvider);
        }

        @Override
        ResourceIterator<StoreFileMetadata> files(GetIndexFilesRequest request, NeoStoreDataSource neoStoreDataSource) throws IOException {
            return neoStoreDataSource.getNeoStoreFileListing().getNeoStoreFileIndexListing().getSnapshot(request.indexId());
        }
    }

    public static class GetStoreFileRequestHandler
    extends StoreCopyRequestHandler<GetStoreFileRequest> {
        public GetStoreFileRequestHandler(CatchupServerProtocol protocol, Supplier<NeoStoreDataSource> dataSource, CheckPointerService checkPointerService, StoreFileStreamingProtocol storeFileStreamingProtocol, FileSystemAbstraction fs, LogProvider logProvider) {
            super(protocol, dataSource, checkPointerService, storeFileStreamingProtocol, fs, logProvider);
        }

        @Override
        ResourceIterator<StoreFileMetadata> files(GetStoreFileRequest request, NeoStoreDataSource neoStoreDataSource) throws IOException {
            try (ResourceIterator resourceIterator = neoStoreDataSource.listStoreFiles(false);){
                String fileName = request.file().getName();
                ResourceIterator resourceIterator2 = Iterators.asResourceIterator((Iterator)StoreCopyRequestHandler.onlyOne(resourceIterator.stream().filter(StoreCopyRequestHandler.matchesRequested(fileName)).collect(Collectors.toList()), fileName));
                return resourceIterator2;
            }
        }
    }
}

