/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.io.fs.FileHandle;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;

public class StoreFiles {
    private static final FilenameFilter STORE_FILE_FILTER = (dir, name) -> !name.startsWith("metrics") && !name.startsWith("temp-copy") && !name.startsWith("raft-messages.") && !name.startsWith("debug.") && !name.startsWith("data") && !name.startsWith("store_lock");
    private final FilenameFilter fileFilter;
    private FileSystemAbstraction fs;
    private PageCache pageCache;

    public StoreFiles(FileSystemAbstraction fs, PageCache pageCache) {
        this(fs, pageCache, STORE_FILE_FILTER);
    }

    public StoreFiles(FileSystemAbstraction fs, PageCache pageCache, FilenameFilter fileFilter) {
        this.fs = fs;
        this.pageCache = pageCache;
        this.fileFilter = fileFilter;
    }

    public void delete(File storeDir, LogFiles logFiles) throws IOException {
        File[] txLogs;
        File[] files = this.fs.listFiles(storeDir, this.fileFilter);
        if (files != null) {
            for (File file : files) {
                this.fs.deleteRecursively(file);
            }
        }
        if ((txLogs = this.fs.listFiles(logFiles.logFilesDirectory())) != null) {
            for (File txLog : txLogs) {
                this.fs.deleteFile(txLog);
            }
        }
        Iterable iterator = this.acceptedPageCachedFiles(storeDir)::iterator;
        for (FileHandle fh : iterator) {
            fh.delete();
        }
    }

    private Stream<FileHandle> acceptedPageCachedFiles(File databaseDirectory) throws IOException {
        try {
            Stream stream = this.fs.streamFilesRecursive(databaseDirectory);
            Predicate<FileHandle> acceptableFiles = fh -> this.fileFilter.accept(databaseDirectory, fh.getRelativeFile().getPath());
            return stream.filter(acceptableFiles);
        }
        catch (NoSuchFileException e) {
            return Stream.empty();
        }
    }

    public void moveTo(File source, File target, LogFiles logFiles) throws IOException {
        this.fs.mkdirs(logFiles.logFilesDirectory());
        for (File candidate : this.fs.listFiles(source, this.fileFilter)) {
            File destination = logFiles.isLogFile(candidate) ? logFiles.logFilesDirectory() : target;
            this.fs.moveToDirectory(candidate, destination);
        }
        Iterable fileHandles = this.acceptedPageCachedFiles(source)::iterator;
        for (FileHandle fh : fileHandles) {
            fh.rename(new File(target, fh.getRelativeFile().getPath()), new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        }
    }

    public boolean isEmpty(File storeDir, Collection<File> filesToLookFor) throws IOException {
        File[] files = this.fs.listFiles(storeDir, this.fileFilter);
        if (files != null) {
            for (File file : files) {
                if (!filesToLookFor.contains(file)) continue;
                return false;
            }
        }
        Iterable fileHandles = this.acceptedPageCachedFiles(storeDir)::iterator;
        for (FileHandle fh : fileHandles) {
            if (!filesToLookFor.contains(fh.getFile())) continue;
            return false;
        }
        return true;
    }

    public StoreId readStoreId(DatabaseLayout databaseLayout) throws IOException {
        File neoStoreFile = databaseLayout.metadataStore();
        org.neo4j.storageengine.api.StoreId kernelStoreId = MetaDataStore.getStoreId((PageCache)this.pageCache, (File)neoStoreFile);
        return new StoreId(kernelStoreId.getCreationTime(), kernelStoreId.getRandomId(), kernelStoreId.getUpgradeTime(), kernelStoreId.getUpgradeId());
    }
}

