/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.File;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.util.Objects;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;

class StoreResource {
    private final File file;
    private final String path;
    private final int recordSize;
    private final FileSystemAbstraction fs;

    StoreResource(File file, String relativePath, int recordSize, FileSystemAbstraction fs) {
        this.file = file;
        this.path = relativePath;
        this.recordSize = recordSize;
        this.fs = fs;
    }

    ReadableByteChannel open() throws IOException {
        return this.fs.open(this.file, OpenMode.READ);
    }

    public String path() {
        return this.path;
    }

    int recordSize() {
        return this.recordSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreResource that = (StoreResource)o;
        return this.recordSize == that.recordSize && Objects.equals(this.file, that.file) && Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.file, this.path, this.recordSize);
    }

    public String toString() {
        return "StoreResource{path='" + this.path + '\'' + ", recordSize=" + this.recordSize + '}';
    }
}

