/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;

public class BoundedPriorityQueue<E> {
    private final Config config;
    private final Function<E, Long> sizeOf;
    private final BlockingQueue<StableElement> queue;
    private final AtomicLong seqGen = new AtomicLong();
    private final AtomicInteger count = new AtomicInteger();
    private final AtomicLong bytes = new AtomicLong();

    BoundedPriorityQueue(Config config, Function<E, Long> sizeOf, java.util.Comparator<E> comparator) {
        this.config = config;
        this.sizeOf = sizeOf;
        this.queue = new PriorityBlockingQueue<StableElement>(config.maxCount, new Comparator(comparator));
    }

    public int count() {
        return this.count.get();
    }

    public long bytes() {
        return this.bytes.get();
    }

    public Result offer(E element) {
        int updatedCount = this.count.incrementAndGet();
        if (updatedCount > this.config.maxCount) {
            this.count.decrementAndGet();
            return Result.E_COUNT_EXCEEDED;
        }
        long elementBytes = this.sizeOf.apply(element);
        long updatedBytes = this.bytes.addAndGet(elementBytes);
        if (elementBytes != 0L && updatedCount > this.config.minCount && updatedBytes > this.config.maxBytes) {
            this.bytes.addAndGet(-elementBytes);
            this.count.decrementAndGet();
            return Result.E_SIZE_EXCEEDED;
        }
        if (!this.queue.offer(new StableElement(element))) {
            throw new IllegalStateException();
        }
        return Result.OK;
    }

    private Optional<E> deduct(StableElement element) {
        if (element == null) {
            return Optional.empty();
        }
        this.count.decrementAndGet();
        this.bytes.addAndGet(-this.sizeOf.apply(element.element).longValue());
        return Optional.of(element.element);
    }

    public Optional<E> poll() {
        return this.deduct((StableElement)this.queue.poll());
    }

    public Optional<E> poll(int timeout, TimeUnit unit) throws InterruptedException {
        return this.deduct(this.queue.poll(timeout, unit));
    }

    Optional<Removable<E>> peek() {
        return Optional.ofNullable(this.queue.peek());
    }

    class Comparator
    implements java.util.Comparator<StableElement> {
        private final java.util.Comparator<E> comparator;

        Comparator(java.util.Comparator<E> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(StableElement o1, StableElement o2) {
            int compare = this.comparator.compare(o1.element, o2.element);
            if (compare != 0) {
                return compare;
            }
            return Long.compare(o1.seqNo, o2.seqNo);
        }
    }

    class StableElement
    implements Removable<E> {
        private final long seqNo;
        private final E element;

        StableElement(E element) {
            this.seqNo = BoundedPriorityQueue.this.seqGen.getAndIncrement();
            this.element = element;
        }

        @Override
        public E get() {
            return this.element;
        }

        @Override
        public boolean remove() {
            boolean removed = BoundedPriorityQueue.this.queue.remove(this);
            if (removed) {
                BoundedPriorityQueue.this.deduct(this);
            }
            return removed;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StableElement that = (StableElement)o;
            return this.seqNo == that.seqNo;
        }

        public int hashCode() {
            return Objects.hash(this.seqNo);
        }
    }

    public static enum Result {
        OK,
        E_COUNT_EXCEEDED,
        E_SIZE_EXCEEDED;

    }

    public static interface Removable<E> {
        public E get();

        public boolean remove();

        default public <T> Removable<T> map(final Function<E, T> fn) {
            return new Removable<T>(){

                @Override
                public T get() {
                    return fn.apply(this.get());
                }

                @Override
                public boolean remove() {
                    return this.remove();
                }
            };
        }
    }

    public static class Config {
        private final int minCount;
        private final int maxCount;
        private final long maxBytes;

        public Config(int maxCount, long maxBytes) {
            this(1, maxCount, maxBytes);
        }

        public Config(int minCount, int maxCount, long maxBytes) {
            this.minCount = minCount;
            this.maxCount = maxCount;
            this.maxBytes = maxBytes;
        }
    }
}

