/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.List;
import java.util.function.Function;
import java.util.logging.Level;
import org.neo4j.causalclustering.core.DiscoveryType;
import org.neo4j.causalclustering.core.consensus.log.cache.InFlightCacheFactory;
import org.neo4j.causalclustering.discovery.DiscoveryServiceFactorySelector;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.Internal;
import org.neo4j.configuration.LoadableConfig;
import org.neo4j.configuration.ReplacedBy;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.kernel.configuration.Settings;

@Description(value="Settings for Causal Clustering")
public class CausalClusteringSettings
implements LoadableConfig {
    @Description(value="Time out for a new member to catch up")
    public static final Setting<Duration> join_catch_up_timeout = Settings.setting((String)"causal_clustering.join_catch_up_timeout", (Function)Settings.DURATION, (String)"10m");
    @Description(value="The time limit within which a new leader election will occur if no messages are received.")
    public static final Setting<Duration> leader_election_timeout = Settings.setting((String)"causal_clustering.leader_election_timeout", (Function)Settings.DURATION, (String)"7s");
    @Internal
    @Description(value="Configures the time after which we give up trying to bind to a cluster formed of the other initial discovery members.")
    public static final Setting<Duration> cluster_binding_timeout = Settings.setting((String)"causal_clustering.cluster_binding_timeout", (Function)Settings.DURATION, (String)"5m");
    @Description(value="Prevents the current instance from volunteering to become Raft leader. Defaults to false, and should only be used in exceptional circumstances by expert users. Using this can result in reduced availability for the cluster.")
    public static final Setting<Boolean> refuse_to_be_leader = Settings.setting((String)"causal_clustering.refuse_to_be_leader", (Function)Settings.BOOLEAN, (String)"false");
    @Description(value="The name of the database being hosted by this server instance. This configuration setting may be safely ignored unless deploying a multicluster. Instances may be allocated to distinct sub-clusters by assigning them distinct database names using this setting. For instance if you had 6 instances you could form 2 sub-clusters by assigning half the database name \"foo\", half the name \"bar\". The setting value must match exactly between members of the same sub-cluster. This setting is a one-off: once an instance is configured with a database name it may not be changed in future without using neo4j-admin unbind.")
    public static final Setting<String> database = Settings.setting((String)"causal_clustering.database", (Function)Settings.STRING, (String)"default");
    @Description(value="Enable pre-voting extension to the Raft protocol (this is breaking and must match between the core cluster members)")
    public static final Setting<Boolean> enable_pre_voting = Settings.setting((String)"causal_clustering.enable_pre_voting", (Function)Settings.BOOLEAN, (String)"false");
    @Description(value="The maximum batch size when catching up (in unit of entries)")
    public static final Setting<Integer> catchup_batch_size = Settings.setting((String)"causal_clustering.catchup_batch_size", (Function)Settings.INTEGER, (String)"64");
    @Description(value="The maximum lag allowed before log shipping pauses (in unit of entries)")
    public static final Setting<Integer> log_shipping_max_lag = Settings.setting((String)"causal_clustering.log_shipping_max_lag", (Function)Settings.INTEGER, (String)"256");
    @Internal
    @Description(value="Maximum number of entries in the RAFT in-queue")
    public static final Setting<Integer> raft_in_queue_size = Settings.setting((String)"causal_clustering.raft_in_queue_size", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="Maximum number of bytes in the RAFT in-queue")
    public static final Setting<Long> raft_in_queue_max_bytes = Settings.setting((String)"causal_clustering.raft_in_queue_max_bytes", (Function)Settings.BYTES, (String)"2G");
    @Internal
    @Description(value="Largest batch processed by RAFT in number of entries")
    public static final Setting<Integer> raft_in_queue_max_batch = Settings.setting((String)"causal_clustering.raft_in_queue_max_batch", (Function)Settings.INTEGER, (String)"128");
    @Description(value="Largest batch processed by RAFT in bytes")
    public static final Setting<Long> raft_in_queue_max_batch_bytes = Settings.setting((String)"causal_clustering.raft_in_queue_max_batch_bytes", (Function)Settings.BYTES, (String)"8M");
    @Description(value="Expected number of Core machines in the cluster before startup")
    @Deprecated
    @ReplacedBy(value="causal_clustering.minimum_core_cluster_size_at_formation and causal_clustering.minimum_core_cluster_size_at_runtime")
    public static final Setting<Integer> expected_core_cluster_size = Settings.setting((String)"causal_clustering.expected_core_cluster_size", (Function)Settings.INTEGER, (String)"3");
    @Description(value="Minimum number of Core machines in the cluster at formation. The expected_core_cluster size setting is used when bootstrapping the cluster on first formation. A cluster will not form without the configured amount of cores and this should in general be configured to the full and fixed amount. When using multi-clustering (configuring multiple distinct database names across core hosts), this setting is used to define the minimum size of *each* sub-cluster at formation.")
    public static final Setting<Integer> minimum_core_cluster_size_at_formation = Settings.buildSetting((String)"causal_clustering.minimum_core_cluster_size_at_formation", (Function)Settings.INTEGER, (String)expected_core_cluster_size.getDefaultValue()).constraint(Settings.min((Comparable)Integer.valueOf(2))).build();
    @Description(value="Minimum number of Core machines required to be available at runtime. The consensus group size (core machines successfully voted into the Raft) can shrink and grow dynamically but bounded on the lower end at this number. The intention is in almost all cases for users to leave this setting alone. If you have 5 machines then you can survive failures down to 3 remaining, e.g. with 2 dead members. The three remaining can still vote another replacement member in successfully up to a total of 6 (2 of which are still dead) and then after this, one of the superfluous dead members will be immediately and automatically voted out (so you are left with 5 members in the consensus group, 1 of which is currently dead). Operationally you can now bring the last machine up by bringing in another replacement or repairing the dead one. When using multi-clustering (configuring multiple distinct database names across core hosts), this setting is used to define the minimum size of *each* sub-cluster at runtime.")
    public static final Setting<Integer> minimum_core_cluster_size_at_runtime = Settings.buildSetting((String)"causal_clustering.minimum_core_cluster_size_at_runtime", (Function)Settings.INTEGER, (String)"3").constraint(Settings.min((Comparable)Integer.valueOf(2))).build();
    @Description(value="Network interface and port for the transaction shipping server to listen on. Please note that it is also possible to run the backup client against this port so always limit access to it via the firewall and configure an ssl policy.")
    public static final Setting<ListenSocketAddress> transaction_listen_address = Settings.listenAddress((String)"causal_clustering.transaction_listen_address", (int)6000);
    @Description(value="Advertised hostname/IP address and port for the transaction shipping server.")
    public static final Setting<AdvertisedSocketAddress> transaction_advertised_address = Settings.advertisedAddress((String)"causal_clustering.transaction_advertised_address", transaction_listen_address);
    @Description(value="Network interface and port for the RAFT server to listen on.")
    public static final Setting<ListenSocketAddress> raft_listen_address = Settings.listenAddress((String)"causal_clustering.raft_listen_address", (int)7000);
    @Description(value="Advertised hostname/IP address and port for the RAFT server.")
    public static final Setting<AdvertisedSocketAddress> raft_advertised_address = Settings.advertisedAddress((String)"causal_clustering.raft_advertised_address", raft_listen_address);
    @Description(value="Host and port to bind the cluster member discovery management communication.")
    public static final Setting<ListenSocketAddress> discovery_listen_address = Settings.listenAddress((String)"causal_clustering.discovery_listen_address", (int)5000);
    @Description(value="Advertised cluster member discovery management communication.")
    public static final Setting<AdvertisedSocketAddress> discovery_advertised_address = Settings.advertisedAddress((String)"causal_clustering.discovery_advertised_address", discovery_listen_address);
    @Description(value="A comma-separated list of other members of the cluster to join.")
    public static final Setting<List<AdvertisedSocketAddress>> initial_discovery_members = Settings.setting((String)"causal_clustering.initial_discovery_members", (Function)Settings.list((String)",", (Function)Settings.ADVERTISED_SOCKET_ADDRESS), (String)Settings.NO_DEFAULT);
    @Description(value="Type of in-flight cache.")
    public static final Setting<InFlightCacheFactory.Type> in_flight_cache_type = Settings.setting((String)"causal_clustering.in_flight_cache.type", (Function)Settings.optionsIgnoreCase(InFlightCacheFactory.Type.class), (String)InFlightCacheFactory.Type.CONSECUTIVE.name());
    @Description(value="The maximum number of entries in the in-flight cache.")
    public static final Setting<Integer> in_flight_cache_max_entries = Settings.setting((String)"causal_clustering.in_flight_cache.max_entries", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="The maximum number of bytes in the in-flight cache.")
    public static final Setting<Long> in_flight_cache_max_bytes = Settings.setting((String)"causal_clustering.in_flight_cache.max_bytes", (Function)Settings.BYTES, (String)"2G");
    @Description(value="Address for Kubernetes API")
    public static final Setting<AdvertisedSocketAddress> kubernetes_address = Settings.setting((String)"causal_clustering.kubernetes.address", (Function)Settings.ADVERTISED_SOCKET_ADDRESS, (String)"kubernetes.default.svc:443");
    @Description(value="File location of token for Kubernetes API")
    public static final Setting<File> kubernetes_token = CausalClusteringSettings.pathUnixAbsolute("causal_clustering.kubernetes.token", "/var/run/secrets/kubernetes.io/serviceaccount/token");
    @Description(value="File location of namespace for Kubernetes API")
    public static final Setting<File> kubernetes_namespace = CausalClusteringSettings.pathUnixAbsolute("causal_clustering.kubernetes.namespace", "/var/run/secrets/kubernetes.io/serviceaccount/namespace");
    @Description(value="File location of CA certificate for Kubernetes API")
    public static final Setting<File> kubernetes_ca_crt = CausalClusteringSettings.pathUnixAbsolute("causal_clustering.kubernetes.ca_crt", "/var/run/secrets/kubernetes.io/serviceaccount/ca.crt");
    @Description(value="LabelSelector for Kubernetes API")
    public static final Setting<String> kubernetes_label_selector = Settings.setting((String)"causal_clustering.kubernetes.label_selector", (Function)Settings.STRING, (String)Settings.NO_DEFAULT);
    @Description(value="Service port name for discovery for Kubernetes API")
    public static final Setting<String> kubernetes_service_port_name = Settings.setting((String)"causal_clustering.kubernetes.service_port_name", (Function)Settings.STRING, (String)Settings.NO_DEFAULT);
    @Internal
    @Description(value="The polling interval when attempting to resolve initial_discovery_members from DNS and SRV records.")
    public static final Setting<Duration> discovery_resolution_retry_interval = Settings.setting((String)"causal_clustering.discovery_resolution_retry_interval", (Function)Settings.DURATION, (String)"5s");
    @Internal
    @Description(value="Configures the time after which we give up trying to resolve a DNS/SRV record into a list of initial discovery members.")
    public static final Setting<Duration> discovery_resolution_timeout = Settings.setting((String)"causal_clustering.discovery_resolution_timeout", (Function)Settings.DURATION, (String)"5m");
    @Description(value="Configure the discovery type used for cluster name resolution")
    public static final Setting<DiscoveryType> discovery_type = Settings.setting((String)"causal_clustering.discovery_type", (Function)Settings.optionsIgnoreCase(DiscoveryType.class), (String)DiscoveryType.LIST.name());
    @Internal
    @Description(value="Select the middleware used for cluster topology discovery")
    public static final Setting<DiscoveryServiceFactorySelector.DiscoveryImplementation> discovery_implementation = Settings.setting((String)"causal_clustering.discovery_implementation", (Function)Settings.optionsIgnoreCase(DiscoveryServiceFactorySelector.DiscoveryImplementation.class), (String)DiscoveryServiceFactorySelector.DEFAULT.name());
    @Description(value="Prevents the network middleware from dumping its own logs. Defaults to true.")
    public static final Setting<Boolean> disable_middleware_logging = Settings.setting((String)"causal_clustering.disable_middleware_logging", (Function)Settings.BOOLEAN, (String)"true");
    @Description(value="The level of middleware logging")
    public static final Setting<Integer> middleware_logging_level = Settings.setting((String)"causal_clustering.middleware_logging.level", (Function)Settings.INTEGER, (String)Integer.toString(Level.FINE.intValue()));
    @Internal
    @Description(value="Hazelcast license key")
    public static final Setting<String> hazelcast_license_key = Settings.setting((String)"hazelcast.license_key", (Function)Settings.STRING, (String)Settings.NO_DEFAULT);
    @Internal
    @Description(value="Parallelism level of default dispatcher used by Akka based cluster topology discovery, including cluster, replicator, and discovery actors")
    public static final Setting<Integer> middleware_akka_default_parallelism_level = Settings.setting((String)"causal_clustering.middleware.akka.default-parallelism", (Function)Settings.INTEGER, (String)Integer.toString(2));
    @Internal
    @Description(value="Parallelism level of dispatcher used for communication from Akka based cluster topology discovery ")
    public static final Setting<Integer> middleware_akka_sink_parallelism_level = Settings.setting((String)"causal_clustering.middleware.akka.sink-parallelism", (Function)Settings.INTEGER, (String)Integer.toString(2));
    @Internal
    @Description(value="Akka cluster phi accrual failure detector. How often keep-alive heartbeat messages should be sent to each connection.")
    public static final Setting<Duration> akka_failure_detector_heartbeat_interval = Settings.setting((String)"causal_clustering.middleware.akka.failure_detector.heartbeat_interval", (Function)Settings.DURATION, (String)"1s");
    @Internal
    @Description(value="Akka cluster phi accrual failure detector. Defines the failure detector threshold. A low threshold is prone to generate many wrong suspicions but ensures a quick detection in the event of a real crash. Conversely, a high threshold generates fewer mistakes but needs more time to detect actual crashes.")
    public static final Setting<Double> akka_failure_detector_threshold = Settings.setting((String)"causal_clustering.middleware.akka.failure_detector.threshold", (Function)Settings.DOUBLE, (String)"10.0");
    @Internal
    @Description(value="Akka cluster phi accrual failure detector. Number of the samples of inter-heartbeat arrival times to adaptively calculate the failure timeout for connections.")
    public static final Setting<Integer> akka_failure_detector_max_sample_size = Settings.setting((String)"causal_clustering.middleware.akka.failure_detector.max_sample_size", (Function)Settings.INTEGER, (String)"1000");
    @Internal
    @Description(value="Akka cluster phi accrual failure detector. Minimum standard deviation to use for the normal distribution in AccrualFailureDetector. Too low standard deviation might result in too much sensitivity for sudden, but normal, deviations in heartbeat inter arrival times.")
    public static final Setting<Duration> akka_failure_detector_min_std_deviation = Settings.setting((String)"causal_clustering.middleware.akka.failure_detector.min_std_deviation", (Function)Settings.DURATION, (String)"100ms");
    @Internal
    @Description(value="Akka cluster phi accrual failure detector. Number of potentially lost/delayed heartbeats that will be accepted before considering it to be an anomaly. This margin is important to be able to survive sudden, occasional, pauses in heartbeat arrivals, due to for example garbage collect or network drop.")
    public static final Setting<Duration> akka_failure_detector_acceptable_heartbeat_pause = Settings.setting((String)"causal_clustering.middleware.akka.failure_detector.acceptable_heartbeat_pause", (Function)Settings.DURATION, (String)"4s");
    @Internal
    @Description(value="Akka cluster phi accrual failure detector. Number of member nodes that each member will send heartbeat messages to, i.e. each node will be monitored by this number of other nodes.")
    public static final Setting<Integer> akka_failure_detector_monitored_by_nr_of_members = Settings.setting((String)"causal_clustering.middleware.akka.failure_detector.monitored_by_nr_of_members", (Function)Settings.INTEGER, (String)"5");
    @Internal
    @Description(value="Akka cluster phi accrual failure detector. After the heartbeat request has been sent the first failure detection will start after this period, even though no heartbeat message has been received.")
    public static final Setting<Duration> akka_failure_detector_expected_response_after = Settings.setting((String)"causal_clustering.middleware.akka.failure_detector.expected_response_after", (Function)Settings.DURATION, (String)"1s");
    @Description(value="The maximum file size before the storage file is rotated (in unit of entries)")
    public static final Setting<Integer> last_flushed_state_size = Settings.setting((String)"causal_clustering.last_applied_state_size", (Function)Settings.INTEGER, (String)"1000");
    @Description(value="The maximum file size before the ID allocation file is rotated (in unit of entries)")
    public static final Setting<Integer> id_alloc_state_size = Settings.setting((String)"causal_clustering.id_alloc_state_size", (Function)Settings.INTEGER, (String)"1000");
    @Description(value="The maximum file size before the membership state file is rotated (in unit of entries)")
    public static final Setting<Integer> raft_membership_state_size = Settings.setting((String)"causal_clustering.raft_membership_state_size", (Function)Settings.INTEGER, (String)"1000");
    @Description(value="The maximum file size before the vote state file is rotated (in unit of entries)")
    public static final Setting<Integer> vote_state_size = Settings.setting((String)"causal_clustering.raft_vote_state_size", (Function)Settings.INTEGER, (String)"1000");
    @Description(value="The maximum file size before the term state file is rotated (in unit of entries)")
    public static final Setting<Integer> term_state_size = Settings.setting((String)"causal_clustering.raft_term_state_size", (Function)Settings.INTEGER, (String)"1000");
    @Description(value="The maximum file size before the global session tracker state file is rotated (in unit of entries)")
    public static final Setting<Integer> global_session_tracker_state_size = Settings.setting((String)"causal_clustering.global_session_tracker_state_size", (Function)Settings.INTEGER, (String)"1000");
    @Description(value="The maximum file size before the replicated lock token state file is rotated (in unit of entries)")
    public static final Setting<Integer> replicated_lock_token_state_size = Settings.setting((String)"causal_clustering.replicated_lock_token_state_size", (Function)Settings.INTEGER, (String)"1000");
    @Description(value="The initial timeout until replication is retried. The timeout will increase exponentially.")
    public static final Setting<Duration> replication_retry_timeout_base = Settings.setting((String)"causal_clustering.replication_retry_timeout_base", (Function)Settings.DURATION, (String)"10s");
    @Description(value="The upper limit for the exponentially incremented retry timeout.")
    public static final Setting<Duration> replication_retry_timeout_limit = Settings.setting((String)"causal_clustering.replication_retry_timeout_limit", (Function)Settings.DURATION, (String)"60s");
    @Description(value="The number of operations to be processed before the state machines flush to disk")
    public static final Setting<Integer> state_machine_flush_window_size = Settings.setting((String)"causal_clustering.state_machine_flush_window_size", (Function)Settings.INTEGER, (String)"4096");
    @Description(value="The maximum number of operations to be batched during applications of operations in the state machines")
    public static final Setting<Integer> state_machine_apply_max_batch_size = Settings.setting((String)"causal_clustering.state_machine_apply_max_batch_size", (Function)Settings.INTEGER, (String)"16");
    @Description(value="RAFT log pruning strategy")
    public static final Setting<String> raft_log_pruning_strategy = Settings.setting((String)"causal_clustering.raft_log_prune_strategy", (Function)Settings.STRING, (String)"1g size");
    @Description(value="RAFT log implementation")
    public static final Setting<String> raft_log_implementation = Settings.setting((String)"causal_clustering.raft_log_implementation", (Function)Settings.STRING, (String)"SEGMENTED");
    @Description(value="RAFT log rotation size")
    public static final Setting<Long> raft_log_rotation_size = Settings.buildSetting((String)"causal_clustering.raft_log_rotation_size", (Function)Settings.BYTES, (String)"250M").constraint(Settings.min((Comparable)Long.valueOf(1024L))).build();
    @Description(value="RAFT log reader pool size")
    public static final Setting<Integer> raft_log_reader_pool_size = Settings.setting((String)"causal_clustering.raft_log_reader_pool_size", (Function)Settings.INTEGER, (String)"8");
    @Description(value="RAFT log pruning frequency")
    public static final Setting<Duration> raft_log_pruning_frequency = Settings.setting((String)"causal_clustering.raft_log_pruning_frequency", (Function)Settings.DURATION, (String)"10m");
    @Description(value="Enable or disable the dump of all network messages pertaining to the RAFT protocol")
    @Internal
    public static final Setting<Boolean> raft_messages_log_enable = Settings.setting((String)"causal_clustering.raft_messages_log_enable", (Function)Settings.BOOLEAN, (String)"false");
    @Description(value="Path to RAFT messages log.")
    @Internal
    public static final Setting<File> raft_messages_log_path = Settings.derivedSetting((String)"causal_clustering.raft_messages_log_path", (Setting)GraphDatabaseSettings.logs_directory, logs -> new File((File)logs, "raft-messages.log"), (Function)Settings.PATH);
    @Description(value="Interval of pulling updates from cores.")
    public static final Setting<Duration> pull_interval = Settings.setting((String)"causal_clustering.pull_interval", (Function)Settings.DURATION, (String)"1s");
    @Description(value="The catch up protocol times out if the given duration elapses with no network activity. Every message received by the client from the server extends the time out duration.")
    public static final Setting<Duration> catch_up_client_inactivity_timeout = Settings.setting((String)"causal_clustering.catch_up_client_inactivity_timeout", (Function)Settings.DURATION, (String)"10m");
    @Description(value="Maximum retry time per request during store copy. Regular store files and indexes are downloaded in separate requests during store copy. This configures the maximum time failed requests are allowed to resend. ")
    public static final Setting<Duration> store_copy_max_retry_time_per_request = Settings.setting((String)"causal_clustering.store_copy_max_retry_time_per_request", (Function)Settings.DURATION, (String)"20m");
    @Description(value="Maximum backoff timeout for store copy requests")
    @Internal
    public static final Setting<Duration> store_copy_backoff_max_wait = Settings.setting((String)"causal_clustering.store_copy_backoff_max_wait", (Function)Settings.DURATION, (String)"5s");
    @Description(value="Throttle limit for logging unknown cluster member address")
    public static final Setting<Duration> unknown_address_logging_throttle = Settings.setting((String)"causal_clustering.unknown_address_logging_throttle", (Function)Settings.DURATION, (String)"10000ms");
    @Description(value="Maximum transaction batch size for read replicas when applying transactions pulled from core servers.")
    @Internal
    public static final Setting<Integer> read_replica_transaction_applier_batch_size = Settings.setting((String)"causal_clustering.read_replica_transaction_applier_batch_size", (Function)Settings.INTEGER, (String)"64");
    @Description(value="Time To Live before read replica is considered unavailable")
    public static final Setting<Duration> read_replica_time_to_live = Settings.buildSetting((String)"causal_clustering.read_replica_time_to_live", (Function)Settings.DURATION, (String)"1m").constraint(Settings.min((Comparable)Duration.ofSeconds(60L))).build();
    @Description(value="How long drivers should cache the data from the `dbms.cluster.routing.getServers()` procedure.")
    public static final Setting<Duration> cluster_routing_ttl = Settings.buildSetting((String)"causal_clustering.cluster_routing_ttl", (Function)Settings.DURATION, (String)"300s").constraint(Settings.min((Comparable)Duration.ofSeconds(1L))).build();
    @Description(value="Configure if the `dbms.cluster.routing.getServers()` procedure should include followers as read endpoints or return only read replicas. Note: if there are no read replicas in the cluster, followers are returned as read end points regardless the value of this setting. Defaults to true so that followers are available for read-only queries in a typical heterogeneous setup.")
    public static final Setting<Boolean> cluster_allow_reads_on_followers = Settings.setting((String)"causal_clustering.cluster_allow_reads_on_followers", (Function)Settings.BOOLEAN, (String)"true");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of NODE IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> node_id_allocation_size = Settings.setting((String)"causal_clustering.node_id_allocation_size", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of RELATIONSHIP IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> relationship_id_allocation_size = Settings.setting((String)"causal_clustering.relationship_id_allocation_size", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of PROPERTY IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> property_id_allocation_size = Settings.setting((String)"causal_clustering.property_id_allocation_size", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of STRING_BLOCK IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> string_block_id_allocation_size = Settings.setting((String)"causal_clustering.string_block_id_allocation_size", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of ARRAY_BLOCK IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> array_block_id_allocation_size = Settings.setting((String)"causal_clustering.array_block_id_allocation_size", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of PROPERTY_KEY_TOKEN IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> property_key_token_id_allocation_size = Settings.setting((String)"causal_clustering.property_key_token_id_allocation_size", (Function)Settings.INTEGER, (String)"32");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of PROPERTY_KEY_TOKEN_NAME IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> property_key_token_name_id_allocation_size = Settings.setting((String)"causal_clustering.property_key_token_name_id_allocation_size", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of RELATIONSHIP_TYPE_TOKEN IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> relationship_type_token_id_allocation_size = Settings.setting((String)"causal_clustering.relationship_type_token_id_allocation_size", (Function)Settings.INTEGER, (String)"32");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of RELATIONSHIP_TYPE_TOKEN_NAME IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> relationship_type_token_name_id_allocation_size = Settings.setting((String)"causal_clustering.relationship_type_token_name_id_allocation_size", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of LABEL_TOKEN IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> label_token_id_allocation_size = Settings.setting((String)"causal_clustering.label_token_id_allocation_size", (Function)Settings.INTEGER, (String)"32");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of LABEL_TOKEN_NAME IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> label_token_name_id_allocation_size = Settings.setting((String)"causal_clustering.label_token_name_id_allocation_size", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of NEOSTORE_BLOCK IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> neostore_block_id_allocation_size = Settings.setting((String)"causal_clustering.neostore_block_id_allocation_size", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of SCHEMA IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> schema_id_allocation_size = Settings.setting((String)"causal_clustering.schema_id_allocation_size", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of NODE_LABELS IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> node_labels_id_allocation_size = Settings.setting((String)"causal_clustering.node_labels_id_allocation_size", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="The size of the ID allocation requests Core servers will make when they run out of RELATIONSHIP_GROUP IDs. Larger values mean less frequent requests but also result in more unused IDs (and unused disk space) in the event of a crash.")
    public static final Setting<Integer> relationship_group_id_allocation_size = Settings.setting((String)"causal_clustering.relationship_group_id_allocation_size", (Function)Settings.INTEGER, (String)"1024");
    @Description(value="Time between scanning the cluster to refresh current server's view of topology")
    public static final Setting<Duration> cluster_topology_refresh = Settings.buildSetting((String)"causal_clustering.cluster_topology_refresh", (Function)Settings.DURATION, (String)"5s").constraint(Settings.min((Comparable)Duration.ofSeconds(1L))).build();
    @Description(value="An ordered list in descending preference of the strategy which read replicas use to choose the upstream server from which to pull transactional updates.")
    public static final Setting<List<String>> upstream_selection_strategy = Settings.setting((String)"causal_clustering.upstream_selection_strategy", (Function)Settings.list((String)",", (Function)Settings.STRING), (String)"default");
    @Description(value="Configuration of a user-defined upstream selection strategy. The user-defined strategy is used if the list of strategies (`causal_clustering.upstream_selection_strategy`) includes the value `user_defined`. ")
    public static final Setting<String> user_defined_upstream_selection_strategy = Settings.setting((String)"causal_clustering.user_defined_upstream_strategy", (Function)Settings.STRING, (String)"");
    @Description(value="Comma separated list of groups to be used by the connect-randomly-to-server-group selection strategy. The connect-randomly-to-server-group strategy is used if the list of strategies (`causal_clustering.upstream_selection_strategy`) includes the value `connect-randomly-to-server-group`. ")
    public static final Setting<List<String>> connect_randomly_to_server_group_strategy = Settings.setting((String)"causal_clustering.connect-randomly-to-server-group", (Function)Settings.list((String)",", (Function)Settings.STRING), (String)"");
    @Description(value="A list of group names for the server used when configuring load balancing and replication policies.")
    public static final Setting<List<String>> server_groups = Settings.setting((String)"causal_clustering.server_groups", (Function)Settings.list((String)",", (Function)Settings.STRING), (String)"");
    @Description(value="The load balancing plugin to use.")
    public static final Setting<String> load_balancing_plugin = Settings.setting((String)"causal_clustering.load_balancing.plugin", (Function)Settings.STRING, (String)"server_policies");
    @Description(value="Time out for protocol negotiation handshake")
    public static final Setting<Duration> handshake_timeout = Settings.setting((String)"causal_clustering.handshake_timeout", (Function)Settings.DURATION, (String)"20s");
    @Description(value="The configuration must be valid for the configured plugin and usually existsunder matching subkeys, e.g. ..config.server_policies.*This is just a top-level placeholder for the plugin-specific configuration.")
    public static final Setting<String> load_balancing_config = Settings.prefixSetting((String)"causal_clustering.load_balancing.config", (Function)Settings.STRING, (String)"");
    @Description(value="Enables shuffling of the returned load balancing result.")
    public static final Setting<Boolean> load_balancing_shuffle = Settings.setting((String)"causal_clustering.load_balancing.shuffle", (Function)Settings.BOOLEAN, (String)"true");
    @Description(value="Require authorization for access to the Causal Clustering status endpoints.")
    public static final Setting<Boolean> status_auth_enabled = Settings.setting((String)"dbms.security.causal_clustering_status_auth_enabled", (Function)Settings.BOOLEAN, (String)"true");
    @Description(value="Enable multi-data center features. Requires appropriate licensing.")
    public static final Setting<Boolean> multi_dc_license = Settings.setting((String)"causal_clustering.multi_dc_license", (Function)Settings.BOOLEAN, (String)"false");
    @Description(value="Name of the SSL policy to be used by the clustering, as defined under the dbms.ssl.policy.* settings. If no policy is configured then the communication will not be secured.")
    public static final Setting<String> ssl_policy = Settings.prefixSetting((String)"causal_clustering.ssl_policy", (Function)Settings.STRING, (String)Settings.NO_DEFAULT);
    @Description(value="Raft protocol implementation versions that this instance will allow in negotiation as a comma-separated list. Order is not relevant: the greatest value will be preferred. An empty list will allow all supported versions")
    public static final Setting<List<Integer>> raft_implementations = Settings.setting((String)"causal_clustering.protocol_implementations.raft", (Function)Settings.list((String)",", (Function)Settings.INTEGER), (String)"");
    @Description(value="Catchup protocol implementation versions that this instance will allow in negotiation as a comma-separated list. Order is not relevant: the greatest value will be preferred. An empty list will allow all supported versions")
    public static final Setting<List<Integer>> catchup_implementations = Settings.setting((String)"causal_clustering.protocol_implementations.catchup", (Function)Settings.list((String)",", (Function)Settings.INTEGER), (String)"");
    @Description(value="Network compression algorithms that this instance will allow in negotiation as a comma-separated list. Listed in descending order of preference for incoming connections. An empty list implies no compression. For outgoing connections this merely specifies the allowed set of algorithms and the preference of the  remote peer will be used for making the decision. Allowable values: [Gzip,Snappy,Snappy_validating,LZ4,LZ4_high_compression,LZ_validating,LZ4_high_compression_validating]")
    public static final Setting<List<String>> compression_implementations = Settings.setting((String)"causal_clustering.protocol_implementations.compression", (Function)Settings.STRING_LIST, (String)"");

    private static Setting<File> pathUnixAbsolute(String name, String path) {
        File[] roots = File.listRoots();
        Path root = roots.length > 0 ? roots[0].toPath() : Paths.get("//", new String[0]);
        return Settings.setting((String)name, (Function)Settings.PATH, (String)root.resolve(path).toString());
    }
}

