/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiFunction;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.DnsHostnameResolver;
import org.neo4j.causalclustering.discovery.DomainNameResolverImpl;
import org.neo4j.causalclustering.discovery.KubernetesResolver;
import org.neo4j.causalclustering.discovery.NoOpHostnameResolver;
import org.neo4j.causalclustering.discovery.RemoteMembersResolver;
import org.neo4j.causalclustering.discovery.SrvHostnameResolver;
import org.neo4j.causalclustering.discovery.SrvRecordResolverImpl;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.internal.LogService;

public enum DiscoveryType {
    DNS((logService, conf) -> DnsHostnameResolver.resolver(logService, new DomainNameResolverImpl(), conf), CausalClusteringSettings.initial_discovery_members),
    LIST((logService, conf) -> NoOpHostnameResolver.resolver(conf), CausalClusteringSettings.initial_discovery_members),
    SRV((logService, conf) -> SrvHostnameResolver.resolver(logService, new SrvRecordResolverImpl(), conf), CausalClusteringSettings.initial_discovery_members),
    K8S(KubernetesResolver::resolver, CausalClusteringSettings.kubernetes_label_selector, CausalClusteringSettings.kubernetes_service_port_name);

    private final BiFunction<LogService, Config, RemoteMembersResolver> resolverSupplier;
    private final Collection<Setting<?>> requiredSettings;

    private DiscoveryType(BiFunction<LogService, Config, RemoteMembersResolver> resolverSupplier, Setting<?> ... requiredSettings) {
        this.resolverSupplier = resolverSupplier;
        this.requiredSettings = Arrays.asList(requiredSettings);
    }

    public RemoteMembersResolver getHostnameResolver(LogService logService, Config config) {
        return this.resolverSupplier.apply(logService, config);
    }

    public Collection<Setting<?>> requiredSettings() {
        return this.requiredSettings;
    }
}

