/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core;

import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.graphdb.security.WriteOperationsNotAllowedException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.factory.AccessCapability;

public class LeaderCanWrite
implements AccessCapability {
    private RaftMachine raftMachine;
    public static final String NOT_LEADER_ERROR_MSG = "No write operations are allowed directly on this database. Writes must pass through the leader. The role of this server is: %s";

    LeaderCanWrite(RaftMachine raftMachine) {
        this.raftMachine = raftMachine;
    }

    public void assertCanWrite() {
        Role currentRole = this.raftMachine.currentRole();
        if (!currentRole.equals((Object)Role.LEADER)) {
            throw new WriteOperationsNotAllowedException(String.format(NOT_LEADER_ERROR_MSG, new Object[]{currentRole}), (Status)Status.Cluster.NotALeader);
        }
    }
}

