/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus;

import java.io.File;
import java.time.Duration;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.EnterpriseCoreEditionModule;
import org.neo4j.causalclustering.core.consensus.DurationSinceLastMessageMonitor;
import org.neo4j.causalclustering.core.consensus.LeaderAvailabilityTimers;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.log.InMemoryRaftLog;
import org.neo4j.causalclustering.core.consensus.log.MonitoredRaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.cache.InFlightCache;
import org.neo4j.causalclustering.core.consensus.log.cache.InFlightCacheFactory;
import org.neo4j.causalclustering.core.consensus.log.segmented.CoreLogPruningStrategy;
import org.neo4j.causalclustering.core.consensus.log.segmented.CoreLogPruningStrategyFactory;
import org.neo4j.causalclustering.core.consensus.log.segmented.SegmentedRaftLog;
import org.neo4j.causalclustering.core.consensus.membership.MemberIdSetBuilder;
import org.neo4j.causalclustering.core.consensus.membership.RaftMembershipManager;
import org.neo4j.causalclustering.core.consensus.membership.RaftMembershipState;
import org.neo4j.causalclustering.core.consensus.schedule.TimerService;
import org.neo4j.causalclustering.core.consensus.shipping.RaftLogShippingManager;
import org.neo4j.causalclustering.core.consensus.term.MonitoredTermStateStorage;
import org.neo4j.causalclustering.core.consensus.term.TermState;
import org.neo4j.causalclustering.core.consensus.vote.VoteState;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.core.replication.SendToMyself;
import org.neo4j.causalclustering.core.state.storage.DurableStateStorage;
import org.neo4j.causalclustering.core.state.storage.SafeChannelMarshal;
import org.neo4j.causalclustering.core.state.storage.StateStorage;
import org.neo4j.causalclustering.discovery.CoreTopologyService;
import org.neo4j.causalclustering.discovery.RaftCoreTopologyConnector;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.Outbound;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.causalclustering.messaging.marshalling.CoreReplicatedContentMarshal;
import org.neo4j.graphdb.factory.module.PlatformModule;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.time.Clocks;

public class ConsensusModule {
    public static final String RAFT_MEMBERSHIP_NAME = "membership";
    public static final String RAFT_TERM_NAME = "term";
    public static final String RAFT_VOTE_NAME = "vote";
    private final MonitoredRaftLog raftLog;
    private final RaftMachine raftMachine;
    private final RaftMembershipManager raftMembershipManager;
    private final InFlightCache inFlightCache;
    private final LeaderAvailabilityTimers leaderAvailabilityTimers;

    public ConsensusModule(MemberId myself, PlatformModule platformModule, Outbound<MemberId, RaftMessages.RaftMessage> outbound, File clusterStateDirectory, CoreTopologyService coreTopologyService) {
        Config config = platformModule.config;
        LogService logging = platformModule.logging;
        FileSystemAbstraction fileSystem = platformModule.fileSystem;
        LifeSupport life = platformModule.life;
        LogProvider logProvider = logging.getInternalLogProvider();
        SafeChannelMarshal<ReplicatedContent> marshal = CoreReplicatedContentMarshal.marshaller();
        RaftLog underlyingLog = this.createRaftLog(config, life, fileSystem, clusterStateDirectory, marshal, logProvider, platformModule.jobScheduler);
        this.raftLog = new MonitoredRaftLog(underlyingLog, platformModule.monitors);
        StateStorage durableTermState = (StateStorage)life.add(new DurableStateStorage<TermState>(fileSystem, clusterStateDirectory, RAFT_TERM_NAME, new TermState.Marshal(), (Integer)config.get(CausalClusteringSettings.term_state_size), logProvider));
        MonitoredTermStateStorage termState = new MonitoredTermStateStorage(durableTermState, platformModule.monitors);
        StateStorage voteState = (StateStorage)life.add(new DurableStateStorage<VoteState>(fileSystem, clusterStateDirectory, RAFT_VOTE_NAME, new VoteState.Marshal(new MemberId.Marshal()), (Integer)config.get(CausalClusteringSettings.vote_state_size), logProvider));
        StateStorage raftMembershipStorage = (StateStorage)life.add(new DurableStateStorage<RaftMembershipState>(fileSystem, clusterStateDirectory, RAFT_MEMBERSHIP_NAME, new RaftMembershipState.Marshal(), (Integer)config.get(CausalClusteringSettings.raft_membership_state_size), logProvider));
        TimerService timerService = new TimerService(platformModule.jobScheduler, logProvider);
        this.leaderAvailabilityTimers = this.createElectionTiming(config, timerService, logProvider);
        Integer minimumConsensusGroupSize = (Integer)config.get(CausalClusteringSettings.minimum_core_cluster_size_at_runtime);
        MemberIdSetBuilder memberSetBuilder = new MemberIdSetBuilder();
        SendToMyself leaderOnlyReplicator = new SendToMyself(myself, outbound);
        this.raftMembershipManager = new RaftMembershipManager(leaderOnlyReplicator, memberSetBuilder, this.raftLog, logProvider, minimumConsensusGroupSize, this.leaderAvailabilityTimers.getElectionTimeout(), Clocks.systemClock(), ((Duration)config.get(CausalClusteringSettings.join_catch_up_timeout)).toMillis(), raftMembershipStorage);
        platformModule.dependencies.satisfyDependency((Object)this.raftMembershipManager);
        life.add((Lifecycle)this.raftMembershipManager);
        this.inFlightCache = InFlightCacheFactory.create(config, platformModule.monitors);
        RaftLogShippingManager logShipping = new RaftLogShippingManager(outbound, logProvider, this.raftLog, timerService, Clocks.systemClock(), myself, this.raftMembershipManager, this.leaderAvailabilityTimers.getElectionTimeout(), (Integer)config.get(CausalClusteringSettings.catchup_batch_size), (Integer)config.get(CausalClusteringSettings.log_shipping_max_lag), this.inFlightCache);
        boolean supportsPreVoting = (Boolean)config.get(CausalClusteringSettings.enable_pre_voting);
        this.raftMachine = new RaftMachine(myself, termState, voteState, this.raftLog, this.leaderAvailabilityTimers, outbound, logProvider, this.raftMembershipManager, logShipping, this.inFlightCache, (Boolean)config.get(CausalClusteringSettings.refuse_to_be_leader), supportsPreVoting, platformModule.monitors);
        DurationSinceLastMessageMonitor durationSinceLastMessageMonitor = new DurationSinceLastMessageMonitor();
        platformModule.monitors.addMonitorListener((Object)durationSinceLastMessageMonitor, new String[0]);
        platformModule.dependencies.satisfyDependency((Object)durationSinceLastMessageMonitor);
        String dbName = (String)config.get(CausalClusteringSettings.database);
        life.add((Lifecycle)new RaftCoreTopologyConnector(coreTopologyService, this.raftMachine, dbName));
        life.add((Lifecycle)logShipping);
    }

    private LeaderAvailabilityTimers createElectionTiming(Config config, TimerService timerService, LogProvider logProvider) {
        Duration electionTimeout = (Duration)config.get(CausalClusteringSettings.leader_election_timeout);
        return new LeaderAvailabilityTimers(electionTimeout, electionTimeout.dividedBy(3L), Clocks.systemClock(), timerService, logProvider);
    }

    private RaftLog createRaftLog(Config config, LifeSupport life, FileSystemAbstraction fileSystem, File clusterStateDirectory, ChannelMarshal<ReplicatedContent> marshal, LogProvider logProvider, JobScheduler scheduler) {
        EnterpriseCoreEditionModule.RaftLogImplementation raftLogImplementation = EnterpriseCoreEditionModule.RaftLogImplementation.valueOf((String)config.get(CausalClusteringSettings.raft_log_implementation));
        switch (raftLogImplementation) {
            case IN_MEMORY: {
                return new InMemoryRaftLog();
            }
            case SEGMENTED: {
                long rotateAtSize = (Long)config.get(CausalClusteringSettings.raft_log_rotation_size);
                int readerPoolSize = (Integer)config.get(CausalClusteringSettings.raft_log_reader_pool_size);
                CoreLogPruningStrategy pruningStrategy = new CoreLogPruningStrategyFactory((String)config.get(CausalClusteringSettings.raft_log_pruning_strategy), logProvider).newInstance();
                File directory = new File(clusterStateDirectory, "raft-log");
                return (RaftLog)life.add((Lifecycle)new SegmentedRaftLog(fileSystem, directory, rotateAtSize, marshal, logProvider, readerPoolSize, Clocks.systemClock(), scheduler, pruningStrategy));
            }
        }
        throw new IllegalStateException("Unknown raft log implementation: " + (Object)((Object)raftLogImplementation));
    }

    public RaftLog raftLog() {
        return this.raftLog;
    }

    public RaftMachine raftMachine() {
        return this.raftMachine;
    }

    public RaftMembershipManager raftMembershipManager() {
        return this.raftMembershipManager;
    }

    public InFlightCache inFlightCache() {
        return this.inFlightCache;
    }

    public LeaderAvailabilityTimers getLeaderAvailabilityTimers() {
        return this.leaderAvailabilityTimers;
    }
}

