/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.segmented;

import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class InFlightMap<V> {
    private final SortedMap<Long, V> map = new ConcurrentSkipListMap<Long, V>();
    private volatile boolean enabled;

    public InFlightMap() {
        this(false);
    }

    public InFlightMap(boolean enabled) {
        this.enabled = enabled;
    }

    public void enable() {
        this.enabled = true;
    }

    public void put(Long key, V value) {
        if (!this.enabled) {
            return;
        }
        V previousValue = this.map.putIfAbsent(key, value);
        if (previousValue != null) {
            throw new IllegalArgumentException(String.format("Attempted to register an already seen value to the log entry cache. Key: %s; New Value: %s; Previous Value: %s", key, value, previousValue));
        }
    }

    public V get(Long key) {
        return this.map.get(key);
    }

    public boolean remove(Long key) {
        return this.map.remove(key) != null;
    }

    public void truncate(Long key) {
        this.map.tailMap(key).keySet().forEach(this.map::remove);
    }

    public String toString() {
        return String.format("InFlightMap{map=%s}", this.map);
    }
}

