/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.membership;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.consensus.membership.MembershipWaiter;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class MembershipWaiterLifecycle
extends LifecycleAdapter {
    private final MembershipWaiter membershipWaiter;
    private final long joinCatchupTimeout;
    private final RaftMachine raft;
    private final Log log;

    public MembershipWaiterLifecycle(MembershipWaiter membershipWaiter, long joinCatchupTimeout, RaftMachine raft, LogProvider logProvider) {
        this.membershipWaiter = membershipWaiter;
        this.joinCatchupTimeout = joinCatchupTimeout;
        this.raft = raft;
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
    }

    public void start() throws Throwable {
        CompletableFuture<Boolean> caughtUp = this.membershipWaiter.waitUntilCaughtUpMember(this.raft);
        try {
            caughtUp.get(this.joinCatchupTimeout, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            this.log.error("Server failed to join cluster", e.getCause());
            throw e.getCause();
        }
        catch (InterruptedException | TimeoutException e) {
            String message = String.format("Server failed to join cluster within catchup time limit [%d ms]", this.joinCatchupTimeout);
            this.log.error(message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
        finally {
            caughtUp.cancel(true);
        }
    }
}

