/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.term;

import java.io.IOException;
import org.neo4j.causalclustering.core.state.storage.SafeStateMarshal;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class TermState {
    private volatile long term;

    public TermState() {
    }

    private TermState(long term) {
        this.term = term;
    }

    public long currentTerm() {
        return this.term;
    }

    public boolean update(long newTerm) {
        this.failIfInvalid(newTerm);
        boolean changed = this.term != newTerm;
        this.term = newTerm;
        return changed;
    }

    private void failIfInvalid(long newTerm) {
        if (newTerm < this.term) {
            throw new IllegalArgumentException("Cannot move to a lower term");
        }
    }

    public String toString() {
        return "TermState{term=" + this.term + '}';
    }

    public static class Marshal
    extends SafeStateMarshal<TermState> {
        @Override
        public void marshal(TermState termState, WritableChannel channel) throws IOException {
            channel.putLong(termState.currentTerm());
        }

        @Override
        protected TermState unmarshal0(ReadableChannel channel) throws IOException {
            return new TermState(channel.getLong());
        }

        @Override
        public TermState startState() {
            return new TermState();
        }

        @Override
        public long ordinal(TermState state) {
            return state.currentTerm();
        }
    }
}

