/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.replication;

import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import org.neo4j.causalclustering.catchup.storecopy.LocalDatabase;
import org.neo4j.causalclustering.core.consensus.LeaderInfo;
import org.neo4j.causalclustering.core.consensus.LeaderListener;
import org.neo4j.causalclustering.core.consensus.LeaderLocator;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.replication.DistributedOperation;
import org.neo4j.causalclustering.core.replication.LeaderProvider;
import org.neo4j.causalclustering.core.replication.Progress;
import org.neo4j.causalclustering.core.replication.ProgressTracker;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.core.replication.ReplicationFailureException;
import org.neo4j.causalclustering.core.replication.Replicator;
import org.neo4j.causalclustering.core.replication.monitoring.ReplicationMonitor;
import org.neo4j.causalclustering.core.replication.session.LocalSessionPool;
import org.neo4j.causalclustering.core.replication.session.OperationContext;
import org.neo4j.causalclustering.helper.TimeoutStrategy;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.Outbound;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.availability.UnavailableException;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class RaftReplicator
implements Replicator,
LeaderListener {
    private final MemberId me;
    private final Outbound<MemberId, RaftMessages.RaftMessage> outbound;
    private final ProgressTracker progressTracker;
    private final LocalSessionPool sessionPool;
    private final TimeoutStrategy progressTimeoutStrategy;
    private final AvailabilityGuard availabilityGuard;
    private final Log log;
    private final LocalDatabase localDatabase;
    private final ReplicationMonitor replicationMonitor;
    private final long availabilityTimeoutMillis;
    private final LeaderProvider leaderProvider;

    public RaftReplicator(LeaderLocator leaderLocator, MemberId me, Outbound<MemberId, RaftMessages.RaftMessage> outbound, LocalSessionPool sessionPool, ProgressTracker progressTracker, TimeoutStrategy progressTimeoutStrategy, long availabilityTimeoutMillis, AvailabilityGuard availabilityGuard, LogProvider logProvider, LocalDatabase localDatabase, Monitors monitors) {
        this.me = me;
        this.outbound = outbound;
        this.progressTracker = progressTracker;
        this.sessionPool = sessionPool;
        this.progressTimeoutStrategy = progressTimeoutStrategy;
        this.availabilityTimeoutMillis = availabilityTimeoutMillis;
        this.availabilityGuard = availabilityGuard;
        this.log = logProvider.getLog(this.getClass());
        this.localDatabase = localDatabase;
        this.replicationMonitor = (ReplicationMonitor)monitors.newMonitor(ReplicationMonitor.class, new String[0]);
        this.leaderProvider = new LeaderProvider();
        leaderLocator.registerListener(this);
    }

    @Override
    public Future<Object> replicate(ReplicatedContent command, boolean trackResult) throws ReplicationFailureException {
        MemberId currentLeader = this.leaderProvider.currentLeader();
        if (currentLeader == null) {
            throw new ReplicationFailureException("Replication aborted since no leader was available");
        }
        return this.replicate0(command, trackResult, currentLeader);
    }

    private Future<Object> replicate0(ReplicatedContent command, boolean trackResult, MemberId leader) throws ReplicationFailureException {
        this.replicationMonitor.startReplication();
        try {
            OperationContext session = this.sessionPool.acquireSession();
            DistributedOperation operation = new DistributedOperation(command, session.globalSession(), session.localOperationId());
            Progress progress = this.progressTracker.start(operation);
            TimeoutStrategy.Timeout progressTimeout = this.progressTimeoutStrategy.newTimeout();
            int attempts = 0;
            try {
                while (true) {
                    if (++attempts > 1) {
                        this.log.info("Retrying replication. Current attempt: %d Content: %s", new Object[]{attempts, command});
                    }
                    this.replicationMonitor.replicationAttempt();
                    this.assertDatabaseAvailable();
                    this.outbound.send(leader, new RaftMessages.NewEntry.Request(this.me, operation), true);
                    progress.awaitReplication(progressTimeout.getMillis());
                    if (!progress.isReplicated()) {
                        progressTimeout.increment();
                        leader = this.leaderProvider.awaitLeader();
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                this.progressTracker.abort(operation);
                throw new ReplicationFailureException("Interrupted while replicating", e);
            }
            BiConsumer<Object, Throwable> cleanup = (ignored1, ignored2) -> this.sessionPool.releaseSession(session);
            if (trackResult) {
                progress.futureResult().whenComplete((BiConsumer)cleanup);
            } else {
                cleanup.accept(null, null);
            }
            this.replicationMonitor.successfulReplication();
            return progress.futureResult();
        }
        catch (Throwable t) {
            this.replicationMonitor.failedReplication(t);
            throw t;
        }
    }

    @Override
    public void onLeaderSwitch(LeaderInfo leaderInfo) {
        this.progressTracker.triggerReplicationEvent();
        MemberId newLeader = leaderInfo.memberId();
        MemberId oldLeader = this.leaderProvider.currentLeader();
        if (newLeader == null && oldLeader != null) {
            this.log.info("Lost previous leader '%s'. Currently no available leader", new Object[]{oldLeader});
        } else if (newLeader != null && oldLeader == null) {
            this.log.info("A new leader has been detected: '%s'", new Object[]{newLeader});
        }
        this.leaderProvider.setLeader(newLeader);
    }

    private void assertDatabaseAvailable() throws ReplicationFailureException {
        this.localDatabase.assertHealthy(ReplicationFailureException.class);
        try {
            this.availabilityGuard.await(this.availabilityTimeoutMillis);
        }
        catch (UnavailableException e) {
            throw new ReplicationFailureException("Database is not available, transaction cannot be replicated.", e);
        }
    }
}

