/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.neo4j.causalclustering.core.consensus.membership.MembershipEntry;
import org.neo4j.causalclustering.core.replication.session.GlobalSessionTrackerState;
import org.neo4j.causalclustering.core.state.machines.id.IdAllocationState;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenState;
import org.neo4j.causalclustering.core.state.machines.tx.LogIndexTxHeaderEncoding;
import org.neo4j.causalclustering.core.state.snapshot.CoreSnapshot;
import org.neo4j.causalclustering.core.state.snapshot.CoreStateType;
import org.neo4j.causalclustering.core.state.snapshot.RaftCoreState;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.recovery.RecoveryRequiredChecker;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.ReadOnlyTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.WritableChannel;

public class CoreBootstrapper {
    private static final long FIRST_INDEX = 0L;
    private static final long FIRST_TERM = 0L;
    private final DatabaseLayout databaseLayout;
    private final PageCache pageCache;
    private final FileSystemAbstraction fs;
    private final Config config;
    private final LogProvider logProvider;
    private final RecoveryRequiredChecker recoveryRequiredChecker;
    private final Log log;

    CoreBootstrapper(DatabaseLayout databaseLayout, PageCache pageCache, FileSystemAbstraction fs, Config config, LogProvider logProvider, Monitors monitors) {
        this.databaseLayout = databaseLayout;
        this.pageCache = pageCache;
        this.fs = fs;
        this.config = config;
        this.logProvider = logProvider;
        this.log = logProvider.getLog(this.getClass());
        this.recoveryRequiredChecker = new RecoveryRequiredChecker(fs, pageCache, config, monitors);
    }

    public CoreSnapshot bootstrap(Set<MemberId> members) throws Exception {
        if (this.recoveryRequiredChecker.isRecoveryRequiredAt(this.databaseLayout)) {
            String message = "Cannot bootstrap. Recovery is required. Please ensure that the store being seeded comes from a cleanly shutdown instance of Neo4j or a Neo4j backup";
            this.log.error(message);
            throw new IllegalStateException(message);
        }
        StoreFactory factory = new StoreFactory(this.databaseLayout, this.config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.fs), this.pageCache, this.fs, this.logProvider, EmptyVersionContextSupplier.EMPTY);
        NeoStores neoStores = factory.openAllNeoStores(true);
        neoStores.close();
        CoreSnapshot coreSnapshot = new CoreSnapshot(0L, 0L);
        coreSnapshot.add(CoreStateType.ID_ALLOCATION, this.deriveIdAllocationState(this.databaseLayout));
        coreSnapshot.add(CoreStateType.LOCK_TOKEN, new ReplicatedLockTokenState());
        coreSnapshot.add(CoreStateType.RAFT_CORE_STATE, new RaftCoreState(new MembershipEntry(0L, members)));
        coreSnapshot.add(CoreStateType.SESSION_TRACKER, new GlobalSessionTrackerState());
        this.appendNullTransactionLogEntryToSetRaftIndexToMinusOne();
        return coreSnapshot;
    }

    private void appendNullTransactionLogEntryToSetRaftIndexToMinusOne() throws IOException {
        long dummyTransactionId;
        ReadOnlyTransactionIdStore readOnlyTransactionIdStore = new ReadOnlyTransactionIdStore(this.pageCache, this.databaseLayout);
        LogFiles logFiles = LogFilesBuilder.activeFilesBuilder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fs, (PageCache)this.pageCache).withConfig(this.config).withLastCommittedTransactionIdSupplier(() -> readOnlyTransactionIdStore.getLastClosedTransactionId() - 1L).build();
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{logFiles});){
            FlushablePositionAwareChannel channel = logFiles.getLogFile().getWriter();
            TransactionLogWriter writer = new TransactionLogWriter(new LogEntryWriter((WritableChannel)channel));
            long lastCommittedTransactionId = readOnlyTransactionIdStore.getLastCommittedTransactionId();
            PhysicalTransactionRepresentation tx = new PhysicalTransactionRepresentation(Collections.emptyList());
            byte[] txHeaderBytes = LogIndexTxHeaderEncoding.encodeLogIndexAsTxHeader(-1L);
            tx.setHeader(txHeaderBytes, -1, -1, -1L, lastCommittedTransactionId, -1L, -1);
            dummyTransactionId = lastCommittedTransactionId + 1L;
            writer.append((TransactionRepresentation)tx, dummyTransactionId);
            channel.prepareForFlush().flush();
        }
        File neoStoreFile = this.databaseLayout.metadataStore();
        MetaDataStore.setRecord((PageCache)this.pageCache, (File)neoStoreFile, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_ID, (long)dummyTransactionId);
    }

    private IdAllocationState deriveIdAllocationState(DatabaseLayout databaseLayout) {
        DefaultIdGeneratorFactory factory = new DefaultIdGeneratorFactory(this.fs);
        long[] highIds = new long[]{CoreBootstrapper.getHighId(factory, IdType.NODE, databaseLayout.idNodeStore()), CoreBootstrapper.getHighId(factory, IdType.RELATIONSHIP, databaseLayout.idRelationshipStore()), CoreBootstrapper.getHighId(factory, IdType.PROPERTY, databaseLayout.idPropertyStore()), CoreBootstrapper.getHighId(factory, IdType.STRING_BLOCK, databaseLayout.idPropertyStringStore()), CoreBootstrapper.getHighId(factory, IdType.ARRAY_BLOCK, databaseLayout.idPropertyArrayStore()), CoreBootstrapper.getHighId(factory, IdType.PROPERTY_KEY_TOKEN, databaseLayout.idPropertyKeyTokenStore()), CoreBootstrapper.getHighId(factory, IdType.PROPERTY_KEY_TOKEN_NAME, databaseLayout.idPropertyKeyTokenNamesStore()), CoreBootstrapper.getHighId(factory, IdType.RELATIONSHIP_TYPE_TOKEN, databaseLayout.idRelationshipTypeTokenStore()), CoreBootstrapper.getHighId(factory, IdType.RELATIONSHIP_TYPE_TOKEN_NAME, databaseLayout.idRelationshipTypeTokenNamesStore()), CoreBootstrapper.getHighId(factory, IdType.LABEL_TOKEN, databaseLayout.idLabelTokenStore()), CoreBootstrapper.getHighId(factory, IdType.LABEL_TOKEN_NAME, databaseLayout.idLabelTokenNamesStore()), CoreBootstrapper.getHighId(factory, IdType.NEOSTORE_BLOCK, databaseLayout.idMetadataStore()), CoreBootstrapper.getHighId(factory, IdType.SCHEMA, databaseLayout.idSchemaStore()), CoreBootstrapper.getHighId(factory, IdType.NODE_LABELS, databaseLayout.idNodeLabelStore()), CoreBootstrapper.getHighId(factory, IdType.RELATIONSHIP_GROUP, databaseLayout.idRelationshipGroupStore())};
        return new IdAllocationState(highIds, 0L);
    }

    private static long getHighId(DefaultIdGeneratorFactory factory, IdType idType, File idFile) {
        IdGenerator idGenerator = factory.open(idFile, idType, () -> -1L, Long.MAX_VALUE);
        long highId = idGenerator.getHighId();
        idGenerator.close();
        return highId;
    }
}

