/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines;

import java.io.File;
import java.time.Clock;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.neo4j.causalclustering.catchup.storecopy.LocalDatabase;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.consensus.LeaderLocator;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.replication.RaftReplicator;
import org.neo4j.causalclustering.core.replication.Replicator;
import org.neo4j.causalclustering.core.state.machines.CoreStateMachines;
import org.neo4j.causalclustering.core.state.machines.dummy.DummyMachine;
import org.neo4j.causalclustering.core.state.machines.id.CommandIndexTracker;
import org.neo4j.causalclustering.core.state.machines.id.IdAllocationState;
import org.neo4j.causalclustering.core.state.machines.id.IdReusabilityCondition;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdAllocationStateMachine;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdGeneratorFactory;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdRangeAcquirer;
import org.neo4j.causalclustering.core.state.machines.locks.LeaderOnlyLockManager;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenState;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenStateMachine;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedLabelTokenHolder;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedPropertyKeyTokenHolder;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedRelationshipTypeTokenHolder;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedTokenStateMachine;
import org.neo4j.causalclustering.core.state.machines.tx.RecoverConsensusLogIndex;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransactionCommitProcess;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransactionStateMachine;
import org.neo4j.causalclustering.core.state.storage.DurableStateStorage;
import org.neo4j.causalclustering.core.state.storage.StateStorage;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.graphdb.factory.EditionLocksFactories;
import org.neo4j.graphdb.factory.module.PlatformModule;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.CommitProcessFactory;
import org.neo4j.kernel.impl.core.TokenHolder;
import org.neo4j.kernel.impl.core.TokenHolders;
import org.neo4j.kernel.impl.core.TokenRegistry;
import org.neo4j.kernel.impl.enterprise.id.EnterpriseIdTypeConfigurationProvider;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.LocksFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.id.configuration.IdTypeConfigurationProvider;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.storageengine.api.StorageEngine;

public class CoreStateMachinesModule {
    public static final String ID_ALLOCATION_NAME = "id-allocation";
    public static final String LOCK_TOKEN_NAME = "lock-token";
    public final IdGeneratorFactory idGeneratorFactory;
    public final IdTypeConfigurationProvider idTypeConfigurationProvider;
    public final TokenHolders tokenHolders;
    public final Supplier<Locks> locksSupplier;
    public final CommitProcessFactory commitProcessFactory;
    public final CoreStateMachines coreStateMachines;
    public final BooleanSupplier freeIdCondition;

    public CoreStateMachinesModule(MemberId myself, PlatformModule platformModule, File clusterStateDirectory, Config config, RaftReplicator replicator, RaftMachine raftMachine, Dependencies dependencies, LocalDatabase localDatabase) {
        LifeSupport life = platformModule.life;
        FileSystemAbstraction fileSystem = platformModule.fileSystem;
        LogService logging = platformModule.logging;
        LogProvider logProvider = logging.getInternalLogProvider();
        StateStorage lockTokenState = (StateStorage)life.add(new DurableStateStorage<ReplicatedLockTokenState>(fileSystem, clusterStateDirectory, LOCK_TOKEN_NAME, new ReplicatedLockTokenState.Marshal(new MemberId.Marshal()), (Integer)config.get(CausalClusteringSettings.replicated_lock_token_state_size), logProvider));
        StateStorage idAllocationState = (StateStorage)life.add(new DurableStateStorage<IdAllocationState>(fileSystem, clusterStateDirectory, ID_ALLOCATION_NAME, new IdAllocationState.Marshal(), (Integer)config.get(CausalClusteringSettings.id_alloc_state_size), logProvider));
        ReplicatedIdAllocationStateMachine idAllocationStateMachine = new ReplicatedIdAllocationStateMachine(idAllocationState);
        Map<IdType, Integer> allocationSizes = this.getIdTypeAllocationSizeFromConfig(config);
        ReplicatedIdRangeAcquirer idRangeAcquirer = new ReplicatedIdRangeAcquirer(replicator, idAllocationStateMachine, allocationSizes, myself, logProvider);
        this.idTypeConfigurationProvider = new EnterpriseIdTypeConfigurationProvider(config);
        CommandIndexTracker commandIndexTracker = (CommandIndexTracker)dependencies.satisfyDependency((Object)new CommandIndexTracker());
        this.freeIdCondition = new IdReusabilityCondition(commandIndexTracker, raftMachine, myself);
        this.idGeneratorFactory = this.createIdGeneratorFactory(fileSystem, idRangeAcquirer, logProvider, this.idTypeConfigurationProvider);
        TokenRegistry relationshipTypeTokenRegistry = new TokenRegistry("RelationshipType");
        Supplier<StorageEngine> storageEngineSupplier = () -> (StorageEngine)localDatabase.dataSource().getDependencyResolver().resolveDependency(StorageEngine.class);
        ReplicatedRelationshipTypeTokenHolder relationshipTypeTokenHolder = new ReplicatedRelationshipTypeTokenHolder(relationshipTypeTokenRegistry, replicator, this.idGeneratorFactory, storageEngineSupplier);
        TokenRegistry propertyKeyTokenRegistry = new TokenRegistry("PropertyKey");
        ReplicatedPropertyKeyTokenHolder propertyKeyTokenHolder = new ReplicatedPropertyKeyTokenHolder(propertyKeyTokenRegistry, replicator, this.idGeneratorFactory, storageEngineSupplier);
        TokenRegistry labelTokenRegistry = new TokenRegistry("Label");
        ReplicatedLabelTokenHolder labelTokenHolder = new ReplicatedLabelTokenHolder(labelTokenRegistry, replicator, this.idGeneratorFactory, storageEngineSupplier);
        ReplicatedLockTokenStateMachine replicatedLockTokenStateMachine = new ReplicatedLockTokenStateMachine(lockTokenState);
        VersionContextSupplier versionContextSupplier = platformModule.versionContextSupplier;
        ReplicatedTokenStateMachine labelTokenStateMachine = new ReplicatedTokenStateMachine(labelTokenRegistry, logProvider, versionContextSupplier);
        ReplicatedTokenStateMachine propertyKeyTokenStateMachine = new ReplicatedTokenStateMachine(propertyKeyTokenRegistry, logProvider, versionContextSupplier);
        ReplicatedTokenStateMachine relationshipTypeTokenStateMachine = new ReplicatedTokenStateMachine(relationshipTypeTokenRegistry, logProvider, versionContextSupplier);
        PageCursorTracerSupplier cursorTracerSupplier = platformModule.tracers.pageCursorTracerSupplier;
        ReplicatedTransactionStateMachine replicatedTxStateMachine = new ReplicatedTransactionStateMachine(commandIndexTracker, replicatedLockTokenStateMachine, (Integer)config.get(CausalClusteringSettings.state_machine_apply_max_batch_size), logProvider, cursorTracerSupplier, versionContextSupplier);
        dependencies.satisfyDependencies(new Object[]{replicatedTxStateMachine});
        LocksFactory lockFactory = EditionLocksFactories.createLockFactory((Config)config, (LogService)logging);
        this.locksSupplier = () -> this.createLockManager(lockFactory, config, (Clock)platformModule.clock, replicator, myself, raftMachine, replicatedLockTokenStateMachine);
        RecoverConsensusLogIndex consensusLogIndexRecovery = new RecoverConsensusLogIndex(localDatabase, logProvider);
        this.coreStateMachines = new CoreStateMachines(replicatedTxStateMachine, labelTokenStateMachine, relationshipTypeTokenStateMachine, propertyKeyTokenStateMachine, replicatedLockTokenStateMachine, idAllocationStateMachine, new DummyMachine(), localDatabase, consensusLogIndexRecovery);
        this.commitProcessFactory = (appender, applier, ignored) -> {
            localDatabase.registerCommitProcessDependencies(appender, applier);
            return new ReplicatedTransactionCommitProcess(replicator);
        };
        this.tokenHolders = new TokenHolders((TokenHolder)propertyKeyTokenHolder, (TokenHolder)labelTokenHolder, (TokenHolder)relationshipTypeTokenHolder);
        dependencies.satisfyDependencies(new Object[]{this.tokenHolders});
    }

    private Map<IdType, Integer> getIdTypeAllocationSizeFromConfig(Config config) {
        HashMap<IdType, Integer> allocationSizes = new HashMap<IdType, Integer>(IdType.values().length);
        allocationSizes.put(IdType.NODE, (Integer)config.get(CausalClusteringSettings.node_id_allocation_size));
        allocationSizes.put(IdType.RELATIONSHIP, (Integer)config.get(CausalClusteringSettings.relationship_id_allocation_size));
        allocationSizes.put(IdType.PROPERTY, (Integer)config.get(CausalClusteringSettings.property_id_allocation_size));
        allocationSizes.put(IdType.STRING_BLOCK, (Integer)config.get(CausalClusteringSettings.string_block_id_allocation_size));
        allocationSizes.put(IdType.ARRAY_BLOCK, (Integer)config.get(CausalClusteringSettings.array_block_id_allocation_size));
        allocationSizes.put(IdType.PROPERTY_KEY_TOKEN, (Integer)config.get(CausalClusteringSettings.property_key_token_id_allocation_size));
        allocationSizes.put(IdType.PROPERTY_KEY_TOKEN_NAME, (Integer)config.get(CausalClusteringSettings.property_key_token_name_id_allocation_size));
        allocationSizes.put(IdType.RELATIONSHIP_TYPE_TOKEN, (Integer)config.get(CausalClusteringSettings.relationship_type_token_id_allocation_size));
        allocationSizes.put(IdType.RELATIONSHIP_TYPE_TOKEN_NAME, (Integer)config.get(CausalClusteringSettings.relationship_type_token_name_id_allocation_size));
        allocationSizes.put(IdType.LABEL_TOKEN, (Integer)config.get(CausalClusteringSettings.label_token_id_allocation_size));
        allocationSizes.put(IdType.LABEL_TOKEN_NAME, (Integer)config.get(CausalClusteringSettings.label_token_name_id_allocation_size));
        allocationSizes.put(IdType.NEOSTORE_BLOCK, (Integer)config.get(CausalClusteringSettings.neostore_block_id_allocation_size));
        allocationSizes.put(IdType.SCHEMA, (Integer)config.get(CausalClusteringSettings.schema_id_allocation_size));
        allocationSizes.put(IdType.NODE_LABELS, (Integer)config.get(CausalClusteringSettings.node_labels_id_allocation_size));
        allocationSizes.put(IdType.RELATIONSHIP_GROUP, (Integer)config.get(CausalClusteringSettings.relationship_group_id_allocation_size));
        return allocationSizes;
    }

    private IdGeneratorFactory createIdGeneratorFactory(FileSystemAbstraction fileSystem, ReplicatedIdRangeAcquirer idRangeAcquirer, LogProvider logProvider, IdTypeConfigurationProvider idTypeConfigurationProvider) {
        return new ReplicatedIdGeneratorFactory(fileSystem, idRangeAcquirer, logProvider, idTypeConfigurationProvider);
    }

    private Locks createLockManager(LocksFactory locksFactory, Config config, Clock clock, Replicator replicator, MemberId myself, LeaderLocator leaderLocator, ReplicatedLockTokenStateMachine lockTokenStateMachine) {
        Locks localLocks = EditionLocksFactories.createLockManager((LocksFactory)locksFactory, (Config)config, (Clock)clock);
        return new LeaderOnlyLockManager(myself, replicator, leaderLocator, localLocks, lockTokenStateMachine);
    }
}

