/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.dummy;

import io.netty.buffer.ByteBuf;
import io.netty.handler.stream.ChunkedInput;
import java.io.IOException;
import java.util.Arrays;
import java.util.OptionalLong;
import java.util.function.Consumer;
import org.neo4j.causalclustering.core.state.CommandDispatcher;
import org.neo4j.causalclustering.core.state.Result;
import org.neo4j.causalclustering.core.state.machines.tx.CoreReplicatedContent;
import org.neo4j.causalclustering.core.state.storage.SafeChannelMarshal;
import org.neo4j.causalclustering.messaging.marshalling.ByteArrayChunkedEncoder;
import org.neo4j.causalclustering.messaging.marshalling.ReplicatedContentHandler;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class DummyRequest
implements CoreReplicatedContent {
    private final byte[] data;

    public DummyRequest(byte[] data) {
        this.data = data;
    }

    @Override
    public OptionalLong size() {
        return OptionalLong.of(this.data.length);
    }

    @Override
    public void handle(ReplicatedContentHandler contentHandler) throws IOException {
        contentHandler.handle(this);
    }

    public long byteCount() {
        return this.data != null ? (long)this.data.length : 0L;
    }

    @Override
    public void dispatch(CommandDispatcher commandDispatcher, long commandIndex, Consumer<Result> callback) {
        commandDispatcher.dispatch(this, commandIndex, callback);
    }

    public ChunkedInput<ByteBuf> encoder() {
        byte[] array = this.data;
        if (array == null) {
            array = new byte[]{};
        }
        return new ByteArrayChunkedEncoder(array);
    }

    public static DummyRequest decode(ByteBuf byteBuf) {
        int length = byteBuf.readableBytes();
        byte[] array = new byte[length];
        byteBuf.readBytes(array);
        return new DummyRequest(array);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DummyRequest that = (DummyRequest)o;
        return Arrays.equals(this.data, that.data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public static class Marshal
    extends SafeChannelMarshal<DummyRequest> {
        public static final Marshal INSTANCE = new Marshal();

        @Override
        public void marshal(DummyRequest dummy, WritableChannel channel) throws IOException {
            if (dummy.data != null) {
                channel.putInt(dummy.data.length);
                channel.put(dummy.data, dummy.data.length);
            } else {
                channel.putInt(0);
            }
        }

        @Override
        protected DummyRequest unmarshal0(ReadableChannel channel) throws IOException {
            byte[] data;
            int length = channel.getInt();
            if (length > 0) {
                data = new byte[length];
                channel.get(data, length);
            } else {
                data = null;
            }
            return new DummyRequest(data);
        }
    }
}

