/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.locks;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Consumer;
import org.neo4j.causalclustering.core.state.CommandDispatcher;
import org.neo4j.causalclustering.core.state.Result;
import org.neo4j.causalclustering.core.state.machines.locks.LockToken;
import org.neo4j.causalclustering.core.state.machines.tx.CoreReplicatedContent;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.marshalling.ReplicatedContentHandler;

public class ReplicatedLockTokenRequest
implements CoreReplicatedContent,
LockToken {
    private final MemberId owner;
    private final int candidateId;
    static final ReplicatedLockTokenRequest INVALID_REPLICATED_LOCK_TOKEN_REQUEST = new ReplicatedLockTokenRequest(null, -1);

    public ReplicatedLockTokenRequest(MemberId owner, int candidateId) {
        this.owner = owner;
        this.candidateId = candidateId;
    }

    @Override
    public int id() {
        return this.candidateId;
    }

    @Override
    public MemberId owner() {
        return this.owner;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicatedLockTokenRequest that = (ReplicatedLockTokenRequest)o;
        return this.candidateId == that.candidateId && Objects.equals(this.owner, that.owner);
    }

    public int hashCode() {
        return Objects.hash(this.owner, this.candidateId);
    }

    public String toString() {
        return String.format("ReplicatedLockTokenRequest{owner=%s, candidateId=%d}", this.owner, this.candidateId);
    }

    @Override
    public void dispatch(CommandDispatcher commandDispatcher, long commandIndex, Consumer<Result> callback) {
        commandDispatcher.dispatch(this, commandIndex, callback);
    }

    @Override
    public void handle(ReplicatedContentHandler contentHandler) throws IOException {
        contentHandler.handle(this);
    }
}

