/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.token;

import java.io.IOException;
import java.util.Arrays;
import java.util.function.Consumer;
import org.neo4j.causalclustering.core.state.CommandDispatcher;
import org.neo4j.causalclustering.core.state.Result;
import org.neo4j.causalclustering.core.state.machines.token.TokenType;
import org.neo4j.causalclustering.core.state.machines.tx.CoreReplicatedContent;
import org.neo4j.causalclustering.messaging.marshalling.ReplicatedContentHandler;

public class ReplicatedTokenRequest
implements CoreReplicatedContent {
    private final TokenType type;
    private final String tokenName;
    private final byte[] commandBytes;

    public ReplicatedTokenRequest(TokenType type, String tokenName, byte[] commandBytes) {
        this.type = type;
        this.tokenName = tokenName;
        this.commandBytes = commandBytes;
    }

    public TokenType type() {
        return this.type;
    }

    String tokenName() {
        return this.tokenName;
    }

    byte[] commandBytes() {
        return this.commandBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicatedTokenRequest that = (ReplicatedTokenRequest)o;
        if (this.type != that.type) {
            return false;
        }
        if (!this.tokenName.equals(that.tokenName)) {
            return false;
        }
        return Arrays.equals(this.commandBytes, that.commandBytes);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.tokenName.hashCode();
        result = 31 * result + Arrays.hashCode(this.commandBytes);
        return result;
    }

    public String toString() {
        return String.format("ReplicatedTokenRequest{type='%s', name='%s'}", new Object[]{this.type, this.tokenName});
    }

    @Override
    public void dispatch(CommandDispatcher commandDispatcher, long commandIndex, Consumer<Result> callback) {
        commandDispatcher.dispatch(this, commandIndex, callback);
    }

    @Override
    public void handle(ReplicatedContentHandler contentHandler) throws IOException {
        contentHandler.handle(this);
    }
}

