/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.tx;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.neo4j.causalclustering.core.state.machines.tx.ByteArrayReplicatedTransaction;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransaction;
import org.neo4j.causalclustering.core.state.machines.tx.TransactionRepresentationExtractor;
import org.neo4j.causalclustering.core.state.machines.tx.TransactionRepresentationReplicatedTransaction;
import org.neo4j.causalclustering.messaging.NetworkReadableClosableChannelNetty4;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageCommandReaderFactory;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.InvalidLogEntryHandler;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.StorageCommandSerializer;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.WritableChannel;

public class ReplicatedTransactionFactory {
    private ReplicatedTransactionFactory() {
        throw new AssertionError((Object)"Should not be instantiated");
    }

    public static TransactionRepresentation extractTransactionRepresentation(ReplicatedTransaction transactionCommand, byte[] extraHeader) {
        return transactionCommand.extract(new TransactionRepresentationReader(extraHeader));
    }

    public static TransactionRepresentationWriter transactionalRepresentationWriter(TransactionRepresentation transactionCommand) {
        return new TransactionRepresentationWriter(transactionCommand);
    }

    static class TransactionRepresentationWriter {
        private final Iterator<StorageCommand> commands;
        private ThrowingConsumer<WritableChannel, IOException> nextJob = channel -> {
            channel.putInt(tx.getAuthorId());
            channel.putInt(tx.getMasterId());
            channel.putLong(tx.getLatestCommittedTxWhenStarted());
            channel.putLong(tx.getTimeStarted());
            channel.putLong(tx.getTimeCommitted());
            channel.putInt(tx.getLockSessionId());
            byte[] additionalHeader = tx.additionalHeader();
            if (additionalHeader != null) {
                channel.putInt(additionalHeader.length);
                channel.put(additionalHeader, additionalHeader.length);
            } else {
                channel.putInt(0);
            }
        };

        private TransactionRepresentationWriter(TransactionRepresentation tx) {
            this.commands = tx.iterator();
        }

        void write(WritableChannel channel) throws IOException {
            this.nextJob.accept((Object)channel);
            if (this.commands.hasNext()) {
                StorageCommand storageCommand = this.commands.next();
                this.nextJob = c -> new StorageCommandSerializer(c).visit(storageCommand);
            } else {
                this.nextJob = null;
            }
        }

        boolean canWrite() {
            return this.nextJob != null;
        }
    }

    private static class TransactionRepresentationReader
    implements TransactionRepresentationExtractor {
        private final byte[] extraHeader;

        TransactionRepresentationReader(byte[] extraHeader) {
            this.extraHeader = extraHeader;
        }

        @Override
        public TransactionRepresentation extract(TransactionRepresentationReplicatedTransaction replicatedTransaction) {
            return replicatedTransaction.tx();
        }

        @Override
        public TransactionRepresentation extract(ByteArrayReplicatedTransaction replicatedTransaction) {
            ByteBuf buffer = Unpooled.wrappedBuffer((byte[])replicatedTransaction.getTxBytes());
            NetworkReadableClosableChannelNetty4 channel = new NetworkReadableClosableChannelNetty4(buffer);
            return this.read(channel);
        }

        private TransactionRepresentation read(NetworkReadableClosableChannelNetty4 channel) {
            try {
                LogEntryCommand entryRead;
                VersionAwareLogEntryReader reader = new VersionAwareLogEntryReader((CommandReaderFactory)new RecordStorageCommandReaderFactory(), InvalidLogEntryHandler.STRICT);
                int authorId = channel.getInt();
                int masterId = channel.getInt();
                long latestCommittedTxWhenStarted = channel.getLong();
                long timeStarted = channel.getLong();
                long timeCommitted = channel.getLong();
                int lockSessionId = channel.getInt();
                int headerLength = channel.getInt();
                byte[] header = headerLength == 0 ? this.extraHeader : new byte[headerLength];
                channel.get(header, headerLength);
                LinkedList<StorageCommand> commands = new LinkedList<StorageCommand>();
                while ((entryRead = (LogEntryCommand)reader.readLogEntry((ReadableClosablePositionAwareChannel)channel)) != null) {
                    commands.add(entryRead.getCommand());
                }
                PhysicalTransactionRepresentation tx = new PhysicalTransactionRepresentation(commands);
                tx.setHeader(header, masterId, authorId, timeStarted, latestCommittedTxWhenStarted, timeCommitted, lockSessionId);
                return tx;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

