/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.tx;

import io.netty.buffer.ByteBuf;
import io.netty.handler.stream.ChunkedInput;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.neo4j.causalclustering.core.state.machines.tx.ByteArrayReplicatedTransaction;
import org.neo4j.causalclustering.core.state.machines.tx.ChunkedTransaction;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransaction;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransactionFactory;
import org.neo4j.causalclustering.core.state.machines.tx.TransactionRepresentationReplicatedTransaction;
import org.neo4j.causalclustering.messaging.ByteBufBacked;
import org.neo4j.causalclustering.messaging.marshalling.ByteArrayChunkedEncoder;
import org.neo4j.causalclustering.messaging.marshalling.OutputStreamWritableChannel;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class ReplicatedTransactionSerializer {
    private ReplicatedTransactionSerializer() {
    }

    public static ReplicatedTransaction decode(ByteBuf byteBuf) {
        int length = byteBuf.readableBytes();
        byte[] bytes = new byte[length];
        byteBuf.readBytes(bytes);
        return ReplicatedTransaction.from(bytes);
    }

    public static ReplicatedTransaction unmarshal(ReadableChannel channel) throws IOException {
        int txBytesLength = channel.getInt();
        byte[] txBytes = new byte[txBytesLength];
        channel.get(txBytes, txBytesLength);
        return ReplicatedTransaction.from(txBytes);
    }

    public static void marshal(WritableChannel writableChannel, ByteArrayReplicatedTransaction replicatedTransaction) throws IOException {
        int length = replicatedTransaction.getTxBytes().length;
        writableChannel.putInt(length);
        writableChannel.put(replicatedTransaction.getTxBytes(), length);
    }

    public static void marshal(WritableChannel writableChannel, TransactionRepresentationReplicatedTransaction replicatedTransaction) throws IOException {
        if (writableChannel instanceof ByteBufBacked) {
            ByteBuf buffer = ((ByteBufBacked)writableChannel).byteBuf();
            int metaDataIndex = buffer.writerIndex();
            int txStartIndex = metaDataIndex + 4;
            buffer.writerIndex(txStartIndex);
            ReplicatedTransactionSerializer.writeTx(writableChannel, replicatedTransaction.tx());
            int txLength = buffer.writerIndex() - txStartIndex;
            buffer.setInt(metaDataIndex, txLength);
        } else {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(1024);
            OutputStreamWritableChannel outputStreamWritableChannel = new OutputStreamWritableChannel(outputStream);
            ReplicatedTransactionSerializer.writeTx(outputStreamWritableChannel, replicatedTransaction.tx());
            int length = outputStream.size();
            writableChannel.putInt(length);
            writableChannel.put(outputStream.toByteArray(), length);
        }
    }

    private static void writeTx(WritableChannel writableChannel, TransactionRepresentation tx) throws IOException {
        ReplicatedTransactionFactory.TransactionRepresentationWriter txWriter = ReplicatedTransactionFactory.transactionalRepresentationWriter(tx);
        while (txWriter.canWrite()) {
            txWriter.write(writableChannel);
        }
    }

    public static ChunkedInput<ByteBuf> encode(TransactionRepresentationReplicatedTransaction representationReplicatedTransaction) {
        return new ChunkedTransaction(representationReplicatedTransaction.tx());
    }

    public static ChunkedInput<ByteBuf> encode(ByteArrayReplicatedTransaction byteArrayReplicatedTransaction) {
        return new ByteArrayChunkedEncoder(byteArrayReplicatedTransaction.getTxBytes());
    }
}

