/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.snapshot;

import java.util.function.Supplier;
import org.neo4j.causalclustering.catchup.CatchupAddressProvider;
import org.neo4j.causalclustering.catchup.storecopy.DatabaseShutdownException;
import org.neo4j.causalclustering.core.state.CommandApplicationProcess;
import org.neo4j.causalclustering.core.state.snapshot.CoreStateDownloader;
import org.neo4j.causalclustering.helper.TimeoutStrategy;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;

public class PersistentSnapshotDownloader
implements Runnable {
    static final String OPERATION_NAME = "download of snapshot";
    private final CommandApplicationProcess applicationProcess;
    private final CatchupAddressProvider addressProvider;
    private final CoreStateDownloader downloader;
    private final Log log;
    private final TimeoutStrategy.Timeout timeout;
    private final Supplier<DatabaseHealth> dbHealth;
    private final Monitor monitor;
    private volatile State state;
    private volatile boolean keepRunning;

    PersistentSnapshotDownloader(CatchupAddressProvider addressProvider, CommandApplicationProcess applicationProcess, CoreStateDownloader downloader, Log log, TimeoutStrategy.Timeout pauseStrategy, Supplier<DatabaseHealth> dbHealth, Monitors monitors) {
        this.applicationProcess = applicationProcess;
        this.addressProvider = addressProvider;
        this.downloader = downloader;
        this.log = log;
        this.timeout = pauseStrategy;
        this.dbHealth = dbHealth;
        this.monitor = (Monitor)monitors.newMonitor(Monitor.class, new String[0]);
        this.state = State.INITIATED;
        this.keepRunning = true;
    }

    @Override
    public void run() {
        if (!this.moveToRunningState()) {
            return;
        }
        try {
            this.monitor.startedDownloadingSnapshot();
            this.applicationProcess.pauseApplier(OPERATION_NAME);
            while (this.keepRunning && !this.downloader.downloadSnapshot(this.addressProvider)) {
                Thread.sleep(this.timeout.getMillis());
                this.timeout.increment();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.log.warn("Persistent snapshot downloader was interrupted");
        }
        catch (DatabaseShutdownException e) {
            this.log.warn("Store copy aborted due to shut down", (Throwable)e);
        }
        catch (Throwable e) {
            this.log.error("Unrecoverable error during store copy", e);
            this.dbHealth.get().panic(e);
        }
        finally {
            this.applicationProcess.resumeApplier(OPERATION_NAME);
            this.monitor.downloadSnapshotComplete();
            this.state = State.COMPLETED;
        }
    }

    private synchronized boolean moveToRunningState() {
        if (this.state != State.INITIATED) {
            return false;
        }
        this.state = State.RUNNING;
        return true;
    }

    void stop() throws InterruptedException {
        this.keepRunning = false;
        while (!this.hasCompleted()) {
            Thread.sleep(100L);
        }
    }

    boolean hasCompleted() {
        return this.state == State.COMPLETED;
    }

    private static enum State {
        INITIATED,
        RUNNING,
        COMPLETED;

    }

    public static interface Monitor {
        public void startedDownloadingSnapshot();

        public void downloadSnapshotComplete();
    }
}

