/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.causalclustering.core.state.storage.SafeChannelMarshal;
import org.neo4j.causalclustering.messaging.marshalling.StringMarshal;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.SocketAddressParser;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.HttpConnector;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class ClientConnectorAddresses
implements Iterable<ConnectorUri> {
    private final List<ConnectorUri> connectorUris;

    public ClientConnectorAddresses(List<ConnectorUri> connectorUris) {
        this.connectorUris = connectorUris;
    }

    static ClientConnectorAddresses extractFromConfig(Config config) {
        ArrayList<ConnectorUri> connectorUris = new ArrayList<ConnectorUri>();
        List boltConnectors = config.enabledBoltConnectors();
        if (boltConnectors.isEmpty()) {
            throw new IllegalArgumentException("A Bolt connector must be configured to run a cluster");
        }
        boltConnectors.forEach(c -> connectorUris.add(new ConnectorUri(Scheme.bolt, (AdvertisedSocketAddress)config.get(c.advertised_address))));
        config.enabledHttpConnectors().forEach(c -> connectorUris.add(new ConnectorUri(HttpConnector.Encryption.NONE.equals((Object)c.encryptionLevel()) ? Scheme.http : Scheme.https, (AdvertisedSocketAddress)config.get(c.advertised_address))));
        return new ClientConnectorAddresses(connectorUris);
    }

    public AdvertisedSocketAddress boltAddress() {
        return this.connectorUris.stream().filter(connectorUri -> ((ConnectorUri)connectorUri).scheme == Scheme.bolt).findFirst().orElseThrow(() -> new IllegalArgumentException("A Bolt connector must be configured to run a cluster")).socketAddress;
    }

    public List<URI> uriList() {
        return this.connectorUris.stream().map(rec$ -> ((ConnectorUri)rec$).toUri()).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientConnectorAddresses that = (ClientConnectorAddresses)o;
        return Objects.equals(this.connectorUris, that.connectorUris);
    }

    public int hashCode() {
        return Objects.hash(this.connectorUris);
    }

    public String toString() {
        return this.connectorUris.stream().map(ConnectorUri::toString).collect(Collectors.joining(","));
    }

    static ClientConnectorAddresses fromString(String value) {
        return new ClientConnectorAddresses(Stream.of(value.split(",")).map(x$0 -> ConnectorUri.fromString(x$0)).collect(Collectors.toList()));
    }

    @Override
    public Iterator<ConnectorUri> iterator() {
        return this.connectorUris.iterator();
    }

    public static class Marshal
    extends SafeChannelMarshal<ClientConnectorAddresses> {
        @Override
        protected ClientConnectorAddresses unmarshal0(ReadableChannel channel) throws IOException {
            int size = channel.getInt();
            ArrayList<ConnectorUri> connectorUris = new ArrayList<ConnectorUri>(size);
            for (int i = 0; i < size; ++i) {
                String schemeName = StringMarshal.unmarshal(channel);
                String hostName = StringMarshal.unmarshal(channel);
                int port = channel.getInt();
                connectorUris.add(new ConnectorUri(Scheme.valueOf(schemeName), new AdvertisedSocketAddress(hostName, port)));
            }
            return new ClientConnectorAddresses(connectorUris);
        }

        @Override
        public void marshal(ClientConnectorAddresses connectorUris, WritableChannel channel) throws IOException {
            channel.putInt(connectorUris.connectorUris.size());
            for (ConnectorUri uri : connectorUris) {
                StringMarshal.marshal(channel, uri.scheme.name());
                StringMarshal.marshal(channel, uri.socketAddress.getHostname());
                channel.putInt(uri.socketAddress.getPort());
            }
        }
    }

    public static class ConnectorUri {
        private final Scheme scheme;
        private final AdvertisedSocketAddress socketAddress;

        public ConnectorUri(Scheme scheme, AdvertisedSocketAddress socketAddress) {
            this.scheme = scheme;
            this.socketAddress = socketAddress;
        }

        private URI toUri() {
            try {
                return new URI(this.scheme.name().toLowerCase(), null, this.socketAddress.getHostname(), this.socketAddress.getPort(), null, null, null);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public String toString() {
            return this.toUri().toString();
        }

        private static ConnectorUri fromString(String string) {
            URI uri = URI.create(string);
            AdvertisedSocketAddress advertisedSocketAddress = (AdvertisedSocketAddress)SocketAddressParser.socketAddress((String)uri.getAuthority(), AdvertisedSocketAddress::new);
            return new ConnectorUri(Scheme.valueOf(uri.getScheme()), advertisedSocketAddress);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConnectorUri that = (ConnectorUri)o;
            return this.scheme == that.scheme && Objects.equals(this.socketAddress, that.socketAddress);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.scheme, this.socketAddress});
        }
    }

    public static enum Scheme {
        bolt,
        http,
        https;

    }
}

