/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.ClientConnectorAddresses;
import org.neo4j.causalclustering.discovery.DiscoveryServerInfo;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.kernel.configuration.Config;

public class CoreServerInfo
implements DiscoveryServerInfo {
    private final AdvertisedSocketAddress raftServer;
    private final AdvertisedSocketAddress catchupServer;
    private final ClientConnectorAddresses clientConnectorAddresses;
    private final Set<String> groups;
    private final String dbName;
    private final boolean refuseToBeLeader;

    public CoreServerInfo(AdvertisedSocketAddress raftServer, AdvertisedSocketAddress catchupServer, ClientConnectorAddresses clientConnectors, String dbName, boolean refuseToBeLeader) {
        this(raftServer, catchupServer, clientConnectors, Collections.emptySet(), dbName, refuseToBeLeader);
    }

    public CoreServerInfo(AdvertisedSocketAddress raftServer, AdvertisedSocketAddress catchupServer, ClientConnectorAddresses clientConnectorAddresses, Set<String> groups, String dbName, boolean refuseToBeLeader) {
        this.raftServer = raftServer;
        this.catchupServer = catchupServer;
        this.clientConnectorAddresses = clientConnectorAddresses;
        this.groups = groups;
        this.dbName = dbName;
        this.refuseToBeLeader = refuseToBeLeader;
    }

    @Override
    public String getDatabaseName() {
        return this.dbName;
    }

    public AdvertisedSocketAddress getRaftServer() {
        return this.raftServer;
    }

    @Override
    public AdvertisedSocketAddress getCatchupServer() {
        return this.catchupServer;
    }

    @Override
    public ClientConnectorAddresses connectors() {
        return this.clientConnectorAddresses;
    }

    @Override
    public Set<String> groups() {
        return this.groups;
    }

    public boolean refusesToBeLeader() {
        return this.refuseToBeLeader;
    }

    public String toString() {
        return "CoreServerInfo{raftServer=" + this.raftServer + ", catchupServer=" + this.catchupServer + ", clientConnectorAddresses=" + this.clientConnectorAddresses + ", groups=" + this.groups + ", database=" + this.dbName + ", refuseToBeLeader=" + this.refuseToBeLeader + '}';
    }

    public static CoreServerInfo from(Config config) {
        AdvertisedSocketAddress raftAddress = (AdvertisedSocketAddress)config.get(CausalClusteringSettings.raft_advertised_address);
        AdvertisedSocketAddress transactionSource = (AdvertisedSocketAddress)config.get(CausalClusteringSettings.transaction_advertised_address);
        ClientConnectorAddresses clientConnectorAddresses = ClientConnectorAddresses.extractFromConfig(config);
        String dbName = (String)config.get(CausalClusteringSettings.database);
        List groupList = (List)config.get(CausalClusteringSettings.server_groups);
        HashSet<String> groups = new HashSet<String>(groupList);
        boolean refuseToBeLeader = (Boolean)config.get(CausalClusteringSettings.refuse_to_be_leader);
        return new CoreServerInfo(raftAddress, transactionSource, clientConnectorAddresses, groups, dbName, refuseToBeLeader);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoreServerInfo that = (CoreServerInfo)o;
        return this.refuseToBeLeader == that.refuseToBeLeader && Objects.equals(this.raftServer, that.raftServer) && Objects.equals(this.catchupServer, that.catchupServer) && Objects.equals(this.clientConnectorAddresses, that.clientConnectorAddresses) && Objects.equals(this.groups, that.groups) && Objects.equals(this.dbName, that.dbName);
    }

    public int hashCode() {
        return Objects.hash(this.raftServer, this.catchupServer, this.clientConnectorAddresses, this.groups, this.dbName, this.refuseToBeLeader);
    }
}

