/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.CoreTopologyService;

public class CoreTopologyListenerService {
    private final Set<CoreTopologyService.Listener> listeners = ConcurrentHashMap.newKeySet();

    public void addCoreTopologyListener(CoreTopologyService.Listener listener) {
        this.listeners.add(listener);
    }

    public void removeCoreTopologyListener(CoreTopologyService.Listener listener) {
        this.listeners.remove(listener);
    }

    public void notifyListeners(CoreTopology coreTopology) {
        for (CoreTopologyService.Listener listener : this.listeners) {
            String dbName = listener.dbName();
            listener.onCoreTopologyChange(coreTopology.filterTopologyByDb(dbName));
        }
    }
}

